/****************************************************************************/
/* Copyright 1996 MBARI                                                     */
/****************************************************************************/
/* $Header: specprr.h,v 4.4 2001/06/19 12:15:39 oasisa Exp $		    */
/* Summary  : Definitionss for PRR type Spectroradiometer on OASIS mooring  */
/* Filename : specprr.h							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 07/03/96 from specprr.c					    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 03jul96 rah - created from specprr.c					    */
/* $Log:	specprr.h,v $
 * Revision 4.4  2001/06/19  12:15:39  12:15:39  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:58  11:44:58  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.5  96/07/17  13:01:18  13:01:18  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
*/
/****************************************************************************/

#ifndef INCspecprrh
#define INCspecprrh	1

#define PRR_ADDRS	12		/* Max no. addresses for PRR Spectro*/
#define PRR_CHANS	20		/* Max no. A/D channels per PRR addr*/
#define PRRBUFSIZE	((PRR_CHANS + 1) * sizeof(Nat16))
#define PRR_FORMAT	 1		/* Format indicator for PRR data    */

typedef struct				/************************************/
{					/* Struct to accum data for one addr*/
    Nat16	pa_nchans;		/* Number of channels		    */
    Nat16	pa_samples;		/* Number of samples		    */
    Int32	pa_data[PRR_CHANS];	/* Data for each channel	    */
} PrrAccum;				/************************************/

typedef struct				/************************************/
{					/* Struct to hold data from one addr*/
    Nat16	pd_nchans;		/* Number of channels		    */
    Int16	pd_data[PRR_CHANS];	/* Data for each channel	    */
} PrrData;				/************************************/

#endif /* INCspecprrh */
