/************************************************************************/
/* Copyright 1991 MBARI							*/
/************************************************************************/
/* $Header: sem.c,v 4.4 2001/06/19 12:15:19 oasisa Exp $			*/
/* Summary  : Semaphore library for 80C196				*/
/* Filename : sem.c							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 10/18/91							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 10oct91 rah - created						*/
/* $Log:	sem.c,v $
 * Revision 4.4  2001/06/19  12:15:19  12:15:19  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:40  11:44:40  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.0  95/02/21  18:42:39  18:42:39  hebo (Bob Herlien)
 * February '95 Deployment
 * 
 * Revision 2.0  92/08/21  14:45:45  14:45:45  hebo (Bob Herlien)
 * August 1992 deployment
 * 
 * Revision 1.3  92/03/03  16:41:18  16:41:18  hebo (Bob Herlien 408-647-3748)
 * New defaults, restart check, perm power stuff, analog command
 * 
*/
/************************************************************************/
/* This is a simple semaphore library to accompany the NON-PREEMPTIVE	*/
/* task scheduler contained in task.c for the 80C196 uController family.*/
/* This file implements counting semaphores.  Read the notes in task.c	*/
/* for cautions about using the non-preemptive task scheduler.		*/
/************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <task.h>			/* Task library definitions	    */


/********************************/
/*	External Functions	*/
/********************************/

Extern Void		do_dispatch( TaskDesc *td );
Extern TaskDesc		*unready( Void );
Extern Void		ready( Reg TaskDesc *td );


/************************************************************************/
/* Function    : sem_init						*/
/* Purpose     : Initialize a semaphore					*/
/* Inputs      : Semaphore ID, initial count				*/
/* Outputs     : None							*/
/************************************************************************/
	Void
sem_init( SemID sem, Int16 count )
{
    list_init( &(sem->sem_list) );
    sem->sem_cnt = count;

} /* sem_init() */


/************************************************************************/
/* Function    : sem_take						*/
/* Purpose     : Take a semaphore					*/
/* Inputs      : Semaphore ID						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
sem_take( Reg SemID sem )
{
    Reg TaskDesc	*td;

    if ( sem->sem_cnt > 0 )		/* If semaphore not exhausted	*/
	(sem->sem_cnt)--;		/*    take it			*/
    else
    {					/* Semaphore gone		*/
	td = unready();			/* Get our TaskDesc		*/
	td->td_state = PENDING;		/* Mark us pending		*/
	td->td_sem = sem;		/* Show which semaphore		*/
	list_add(&(sem->sem_list), (Node *)td); /* Put us on sempahore list*/
	do_dispatch( td );		/* Dispatch next task		*/
    }

} /* sem_take() */


/************************************************************************/
/* Function    : sem_give						*/
/* Purpose     : Give a semaphore					*/
/* Inputs      : Semaphore ID						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
sem_give( Reg SemID sem )
{
    if ( sem->sem_list.lst_head == NULLNODE )
	sem->sem_cnt++;			/* If nobody waiting, incr count*/
    else				/* else ready top of wait list	*/
	ready( (TaskDesc *)list_head(&sem->sem_list) );

} /* sem_give() */
