/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: oxygen.c,v 4.4 2001/06/19 12:14:58 oasisa Exp $			    */
/* Summary  : Driver Routines for Oxygen Sensor on OASIS mooring	    */
/* Filename : oxygen.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 04/05/95							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 05apr95 rah - created						    */
/* $Log:	oxygen.c,v $
 * Revision 4.4  2001/06/19  12:14:58  12:14:58  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:32  11:44:32  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.4  96/06/18  15:24:30  15:24:30  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.2  95/04/11  14:03:32  14:03:32  hebo (Bob Herlien)
 * Drifter Deployment on IronEx
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <task.h>			/* OASIS Multitasking definitions   */

#define OXYGEN_SIZE	512		/* Size of buffer for nitrate	    */


/********************************/
/*	External Functions	*/
/********************************/

Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );
Extern char	*drvSerPortAndMalloc( Driver *dp, Nat16 size );
Extern Void	drv_ser_release( Driver *dp );
Extern Int16	xgetn_tmout( char *s, Int16 len, Nat16 tmout );
Extern char	*tmpMalloc( Nat16 size );
Extern Void	tmpFree( char *ptr );


/************************************************************************/
/* Function    : oxygen_drv						*/
/* Purpose     : Oxygen Sensor driver					*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
oxygen_drv( Driver *dp )
{
    Reg Int16	len;
    Nat16	i;
    char	*oxygen_buf;		/* Buffer for oxygen data	*/

    if ( (oxygen_buf = drvSerPortAndMalloc(dp, OXYGEN_SIZE)) == NULL )
	return;

    for ( i = 0; i < dp->drv_parms[PARM0]; i++ )
	task_delay( TICKS_PER_SECOND );
    
    while ( (len = xgetn_tmout(oxygen_buf, OXYGEN_SIZE, 
				   dp->drv_parms[TIMEOUT])) > 0 )
	    drvLog( dp, (Byte *)oxygen_buf, len );

    drv_ser_release( dp );		/* Release serial port		*/
    tmpFree( oxygen_buf );		/* Free the buffer		*/

} /* oxygen_drv() */
