$NOLIST

;************************************************************************
;* Copyright 1991 MBARI							*
;************************************************************************
;* Summary  : Definitions for the OASIS mooring controller using 87C196	*
;* Filename : oasis.inc							*
;* Author   : Robert Herlien (rah)					*
;* Project  : OASIS Mooring						*
;* Version  : 1.0							*
;* Created  : 11/12/91							*
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;************************************************************************
;* Modification History:						*
;* 11nov91 rah - created						*
;************************************************************************

EXEC_FROM_RAM	EQU	1		;Copy ROM to RAM at 6000h - 9fffh


;********************************************************
;* Registers Used by C compiler
;* PLMREG is function return register
;  TMP2-6 are temps, can be destroyed by called function
;********************************************************

plmreg		EQU	1CH:WORD	;PLMREG is return register
tmp0		EQU	plmreg:WORD	;Alias for PLMREG
tmp2		EQU	plmreg+2:WORD	;Scratch registers
tmp4		EQU	plmreg+4:WORD
tmp6		EQU	plmreg+6:WORD

tmp0b		EQU	tmp0:BYTE	;tmp0 as a byte reg
tmp1b		EQU	tmp0b+1:BYTE	;Other half of tmp0b
tmp2b		EQU	tmp2:BYTE	;tmp2 as a byte reg
tmp3b		EQU	tmp2b+1:BYTE	;Other half of tmp2b
tmp4b		EQU	tmp4:BYTE	;tmp4 as a byte reg
tmp5b		EQU	tmp4b+1:BYTE	;Other half of tmp4b
tmp6b		EQU	tmp6:BYTE	;tmp6 as a byte reg
tmp7b		EQU	tmp6b+1:BYTE	;Other half of tmp6b


;****************************************
;* Memory layout for OASIS controller	*
;****************************************

RAM_OK		EQU	0c35aH	;Abitrary pattern to signify RAM initialized
PROG_RAM	EQU	06000H	;Start of area with program ROM & RAM
RAM_CHKSUM_LEN	EQU	02000H	;Number of words to checksum RAM
PROG_ROM	EQU	02000H	;Start of ROM
ROM_CHKSUM_LEN	EQU	04000H	;Number of words to checksum ROM
INIT_RAM	EQU	0b000H	;Area of RAM to start init
INIT_LEN	EQU	02800H	;Length of RAM area to init (in words)

IF (EXEC_FROM_RAM)
RAMSELBIT	equ	80h	;Bit to turn on RAM in 0x6000 - 0x9fff area
ELSE
RAMSELBIT	equ	0	;Don't turn on program RAM
ENDIF


;****************************************/
;* Ring structure Definitions
;****************************************/

RING_STRUC_SIZE	EQU	8		;Size of ring structure


;*****************************************************************************
; push_cregs - macro to save the C context for Interrupt Service Routines
;
push_cregs	MACRO	
		push	plmreg
		push	tmp2
		push	tmp4
		push	tmp6
		ENDM

;
;*****************************************************************************
; pop_cregs - macro to restore the C context for Interrupt Service Routines
;  
pop_cregs	MACRO	
		pop	tmp6
		pop	tmp4
		pop	tmp2
		pop	plmreg
		ENDM
;

$LIST
