/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: microcat.c,v 4.4 2001/06/19 12:14:42 oasisa Exp $		    */
/* Summary  : Driver Routines for Seabird serial microCat on OASIS mooring  */
/* Filename : microcat.c						    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 09/01/98 from ctd.c					    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 01sep98 rah - created from ctd.c					    */
/* $Log:	microcat.c,v $
 * Revision 4.4  2001/06/19  12:14:42  12:14:42  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:14  11:44:14  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.2  98/09/09  10:59:51  10:59:51  bobh (Bob Herlien)
 * Sept/Oct '98 deployments of M1, Eqpac 1 & 2
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <custom.h>			/* CTD_TS definition		    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <task.h>			/* OASIS Multitasking definitions   */
#include <stdio.h>			/* Standard I/O functions	    */

#define CTD_BUFSIZE	80              /* Orig 64; add for rec number      */

/********************************/
/*	External Functions	*/
/********************************/

Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );
Extern Void	drv_ser_port( Driver *dp );
Extern Void	drv_ser_release( Driver *dp );
Extern Void	drv_pwroff( Driver *dp );
Extern Void	xputc( Int16 c );
Extern Void	xputs( const char *s );
Extern Int16	xgetc_tmout( Nat16 tmout );
Extern Int16	xgets_tmout( char *s, Int16 len, Nat16 tmout );
Extern MBool	getFixedPt( char **s, Int16 *resultPtr, Nat16 decDigits );
#ifdef ARGOS_CTD
Extern Void	argosCTDSample( Nat16 temp, Nat16 conduct );
#endif


/************************************************************************/
/* Function    : getMicrocat						*/
/* Purpose     : Make one attempt to get Microcat CTD data		*/
/* Inputs      : Buffer, Driver pointer					*/
/* Outputs     : Number of bytes received from CTD, or ERROR		*/
/************************************************************************/
	Int16
getMicrocat( char *ctd_buf, Driver *dp, Int16 *tmp, Int16 *cond )
{
    Int16	c, len;
    Nat16	tmout;
    char	*p;

    xputc('\r');			/* Get CTD's attention		*/
    tmout = dp->drv_parms[TIMEOUT];	/* Get timeout			*/

    while ( (c = xgetc_tmout(tmout)) != '>' )
	if ( c == ERROR )		/* Look for prompt		*/
	    return( ERROR );		/* If timed out, return no data	*/

    xputs("SL\r");			/* Send Last Sample command	*/

    while( (len = xgets_tmout(ctd_buf, CTD_BUFSIZE, tmout)) >= 0 )
    {
	p = ctd_buf;
	if ( getFixedPt(&p, tmp, 3) )
	{
	    p++;
	    if ( getFixedPt(&p, cond, 4) )
		return( len );
	}
    }

    return( ERROR );

} /* getMicrocat() */


/************************************************************************/
/* Function    : microcat_drv						*/
/* Purpose     : Driver for microCat CTD				*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
microcat_drv( Driver *dp )
{
    Int16	i, len, temp, conduct;
    char	ctd_buf[CTD_BUFSIZE];	/* Buffer for CTD data		*/
    
    drv_ser_port( dp );			/* Get serial port		*/

    for ( i = 0; i < dp->drv_parms[PARM0]; i++ )
	if ( (len = getMicrocat(ctd_buf, dp, &temp, &conduct)) > 0 )
	    break;
    
    xputs("QS\r");			/* Turn off microCat		*/
    drv_ser_release( dp );		/* Release serial port		*/
    if ( len > 0 )
    {
	drvLog( dp, (Byte *)ctd_buf, len );	/* Log CTD data		*/
#ifdef ARGOS_CTD
	argosCTDSample( temp, conduct );	/* Send to ARGOS	*/
#endif
    }

    drv_pwroff( dp );			/* Turn off power		*/

} /* microcat_drv() */

