;****************************************************************************
;* Copyright 1991 MBARI                                                     *
;****************************************************************************
;* $Header: list.s,v 4.4 2001/06/19 12:14:24 oasisa Exp $			    *
;* Summary  : List management routines for OASIS Microcontroller	    *
;* Filename : list.s							    *
;* Author   : Robert Herlien						    *
;* Project  : OASIS Mooring Controller                                      *
;* $Revision: 4.4 $							    *
;* Created  : 11/10/91							    *
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;****************************************************************************
;
$TITLE("List Management Routines")
;
LIST		MODULE
;
;*****************************************************************************
;
PUBLIC	list_init		;Init linked list
PUBLIC	list_head		;Get and remove first node of linked list
PUBLIC	list_add		;Add node to end of linked list
PUBLIC	list_get		;Get and remove given node from linked list
PUBLIC	list_first		;Get first node of linked list
PUBLIC	list_next		;Get next node of linked list

$INCLUDE(..\C196\INCLUDE\8096.INC)
$INCLUDE(OASIS.INC)


;******************** List Head Structure *********************************
;
HEAD		EQU	0		;Pointer to first item on list
TAIL		EQU	2		;Pointer to last item on list

;******************** Node Structure *********************************
;
NEXT		EQU	0		;Pointer to next item on list
PREV		EQU	2		;Pointer to previous item on list

			CSEG

;*****************************************************************************
; LIST_INIT - Initialize Linked List
;
; Void list_init( LstHead *lp );
;
list_init:
	ld	plmreg, 2[SP]
	st	R0, HEAD[plmreg]
	st	R0, TAIL[plmreg]
	ret


;*****************************************************************************
; LIST_HEAD - Delete and return head of linked list
;
; Node *list_head( LstHead *lp );
;
list_head:
	ld	tmp2, 2[SP]
	ld	plmreg, HEAD[tmp2]
	cmp	plmreg, R0
	je	lhret

	ld	tmp4, NEXT[plmreg]
	st	tmp4, HEAD[tmp2]
	cmp	tmp4, R0
	je	lh2
	st	R0, PREV[tmp4]
	ret
lh2:
	st	R0, TAIL[tmp2]
lhret:
	ret


;*****************************************************************************
; LIST_ADD - Add a node to the end of a linked list
;
; Void *list_add( LstHead *lp, Node *np );
;
list_add:
	ld	tmp2, 2[SP]
	ld	plmreg, 4[SP]
	ld	tmp4, TAIL[tmp2]
	st	R0, NEXT[plmreg]
	st	tmp4, PREV[plmreg]
	st	plmreg, TAIL[tmp2]
	cmp	tmp4, R0
	je	la1
	st	plmreg, NEXT[tmp4]
	ret
la1:
	st	plmreg, HEAD[tmp2]
	ret


;*****************************************************************************
; LIST_GET - Delete and return a given node from linked list
;
; Node *list_get( LstHead *lp, Node *np );
;
list_get:
	ld	tmp2, 2[SP]
	ld	plmreg, 4[SP]
lg1:
	ld	tmp4, NEXT[plmreg]
	ld	tmp6, PREV[plmreg]
	cmp	tmp6, R0
	je	lg2
	st	tmp4, NEXT[tmp6]
	sjmp	lg3	
lg2:
	st	tmp4, HEAD[tmp2]
lg3:
	cmp	tmp4, R0
	je	lg4
	st	tmp6, PREV[tmp4]
	ret
lg4:
	st	tmp6, TAIL[tmp2]
	ret


;*****************************************************************************
; LIST_FIRST - Return first entry of linked list
;
; Node *list_first( LstHead *lp );
;
list_first:
	ld	tmp2, 2[SP]
	ld	plmreg, HEAD[tmp2]
	ret


;*****************************************************************************
; LIST_NEXT - Return first entry of linked list
;
; Node *list_next( Node *np );
;
list_next:
	ld	tmp2, 2[SP]
	ld	plmreg, NEXT[tmp2]
	ret

	END
