/************************************************************************/
/* Copyright 1991 MBARI							*/
/************************************************************************/
/* $Header: io.h,v 4.4 2001/06/19 12:14:12 oasisa Exp $			*/
/* Summary  : Definitions for the OASIS I/O Bits			*/
/* Filename : io.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 02/06/91							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 06feb91 rah - created						*/
/* $Log:	io.h,v $
 * Revision 4.4  2001/06/19  12:14:12  12:14:12  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:02  11:44:02  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.9  97/10/28  13:59:34  13:59:34  bobh (Bob Herlien)
 * EqPac Deployment of Nov 1997
 * 
 * Revision 3.4  96/06/18  15:24:04  15:24:04  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.3  95/04/13  13:46:44  13:46:44  hebo (Bob Herlien)
 * Drifter Deployment for Coop (flip) cruise
 * 
 * Revision 3.2  95/04/11  14:03:19  14:03:19  hebo (Bob Herlien)
 * Drifter Deployment on IronEx
 * 
 * Revision 3.1  95/03/09  19:30:48  19:30:48  hebo (Bob Herlien)
 * March '95 Deployment of M1A
 * 
 * Revision 3.0  95/02/21  18:42:33  18:42:33  hebo (Bob Herlien)
 * February '95 Deployment
 * 
 * Revision 2.0  92/08/21  14:45:20  14:45:20  hebo (Bob Herlien)
 * August 1992 deployment
 * 
 * Revision 1.3  92/03/03  16:37:42  16:37:42  hebo (Bob Herlien 408-647-3748)
 * Changed input ring size during maintenance turnaround
 * 
*/
/************************************************************************/

#ifndef INCioh
#define INCioh	1

/****************************************/
/* Miscellaneous typedefs and defines	*/
/****************************************/
#define IO		0x200		/* Start of memory mapped I/O	    */
#define CLOCK_SPEED	10		/* 9.8304 MHz clock		    */

#define NSER_PORTS	3		/* Three serial ports		    */
#define NAD_PORTS	8		/* 8 A/D ports			    */
#define CPU_SER		0		/* CPU serial port is port 0	    */
#define UARTA		1		/* UART A handles serial port 1	    */
#define UARTB		2		/* UART B handles serial port 2	    */
#define RCVRING_SIZE	256		/* Size of serial input buffers	256 */
#define XMITRING_SIZE	128		/* Size of serial output buffers    */
#define XON		0x11		/* Xon ASCII character		    */
#define XOFF		0x13		/* Xoff ASCII character		    */

#define BULLWINKLE_RELAYS 8		/* Number of relays on main board   */
#define TOTAL_RELAYS	 16		/* Total number of relays	    */

	/* Bit definitions for "mode" word passed to ser_init()		*/
#define BAUD_MASK	0x07		/* Baud rate should be 4 LSB's, but */
					/*  we're only using 3 bits now	    */
#define PTY_MASK	0x30		/* Parity is bits 4,5		    */
#define BIT8		0x40		/* Bit 6 on for 8 bit, else 7 bit   */
#define BIT7		0		/* 7 bit characters		    */
#define STOP2		0x80		/* Bit 7 on for 2 stop bits, else 1 */
#define STOP1		0		/* 1 stop bit			    */
#define PTY_LEN_STOP	0xf0		/* Parity, stop, len in bits 4-7    */

#define NO_PTY		0		/* No parity			    */
#define EVEN_PTY	0x10		/* Even parity			    */

#define ODD_PTY		0x20		/* Odd parity			    */
#define FLOW		0x100		/* Bit 8 on for XON/XOFF flow control*/
#define ECHO		0x200		/* Bit 9 on for local echo mode	    */
#define NMODE		0xc00		/* Bits 10 & 11 are \n mode	    */
#define AUTOCR		0x400		/* 01 = Add CR before LF	    */
#define NEWCR		0x800		/* 10 = Replace newline with CR	    */
#define NOLF		0xc00		/* 11 = Don't output LF		    */
#define SER_TTL		0x1000		/* Bit 12 high uses TTL drvrs for ser*/

#define BAUD_75		0		/* 75 baud			    */
#define BAUD_300	1		/* 300 baud			    */
#define BAUD_1200	2		/* 1200 baud			    */
#define BAUD_2400	3		/* 2400 baud			    */
#define BAUD_4800	4		/* 4800 baud			    */
#define BAUD_9600	5		/* 9600 baud			    */
#define BAUD_19200	6		/* 19200 baud			    */
#define BAUD_38400	7		/* 38400 baud			    */

#define CPU_CLOCK	9830400L	/* Clock frequency = 9.8304 MHz	    */
#define TICK		6130		/* 6144 states @ 9.83 MHz = 10 ms   */
					/* (minus time for the int handler) */

#define TICKS_PER_SECOND 100		/* Frequency of software time base  */

#define WATCH_COUNT	30000		/* Software watchdog is .5 seconds  */
#define WATCH_FACTOR	(WATCH_COUNT / (TICKS_PER_SECOND/2))

typedef struct				/* RING structure declaration	    */
{					/*  Used for serial data buffering  */
        Byte    *base_ptr;		/* Base address of ring buffer	    */
        Byte    *input_ptr;		/* Input pointer - for reads	    */
        Byte    *output_ptr;            /* Output pointer - for writes	    */
        Byte	*end_ptr;		/* End of ring buffer + 1	    */
} Ring;                                 /* Data structure for ring buffer   */


/************************************************/
/* I/O for OASIS controller			*/
/* The I/O locations are assigned in micro.s	*/
/************************************************/
extern volatile unsigned int	relay0_enbl;	/* at 0x200 & 0x201 : w	*/
extern volatile unsigned char	bank_port;	/* at 0x202:   w	*/
extern volatile unsigned char	oasis_ctrl;	/* at 0x203:   w	*/

extern volatile unsigned int	relay1_enbl;	/* at 0x614 & 0x615 : w	*/
extern volatile unsigned int	pwr_enbl;	/* at 0x600 & 0x601 : w	*/
extern volatile unsigned char	wakeport;	/* at 0x612:   w	*/

extern volatile unsigned char	uarta_data;	/* at 0x210: r w	*/
extern volatile unsigned char	uarta_ucr;	/* at 0x211:   w	*/
extern volatile unsigned char	uarta_usr;	/* at 0x211: r		*/
extern volatile unsigned char	uarta_mcr;	/* at 0x212: r w	*/
extern volatile unsigned char	uarta_brsr;	/* at 0x213:   w	*/
extern volatile unsigned char	uarta_msr;	/* at 0x213: r		*/

extern volatile unsigned char	uartb_data;	/* at 0x220: r w	*/
extern volatile unsigned char	uartb_ucr;	/* at 0x221:   w	*/
extern volatile unsigned char	uartb_usr;	/* at 0x221: r		*/
extern volatile unsigned char	uartb_mcr;	/* at 0x222: r w	*/
extern volatile unsigned char	uartb_brsr;	/* at 0x223:   w	*/
extern volatile unsigned char	uartb_msr;	/* at 0x223: r		*/

extern volatile unsigned char	piaa_p1da;	/* at 0x230: r w	*/
extern volatile unsigned char	piaa_p2da;	/* at 0x231: r w	*/
extern volatile unsigned char	piaa_pda;	/* at 0x232: r w	*/
extern volatile unsigned char	piaa_pdb;	/* at 0x233: r w	*/
extern volatile unsigned char	piaa_pdc;	/* at 0x234: r w	*/
extern volatile unsigned char	piaa_ddra;	/* at 0x236: r w	*/
extern volatile unsigned char	piaa_ddrb;	/* at 0x237: r w	*/
extern volatile unsigned char	piaa_ddrc;	/* at 0x238: r w	*/
extern volatile unsigned char	piaa_cra;	/* at 0x239: r w	*/
extern volatile unsigned char	piaa_crb;	/* at 0x23a: r w	*/
extern volatile unsigned char	piaa_fsr;	/* at 0x23b: r w	*/
extern volatile unsigned char	piaa_p1db;	/* at 0x23c: r w	*/
extern volatile unsigned char	piaa_p2db;	/* at 0x23d: r w	*/
extern volatile unsigned char	piaa_hsr;	/* at 0x23e: r w	*/
extern volatile unsigned char	piaa_hwr;	/* at 0x23f: r w	*/

extern volatile unsigned char	piab_p1da;	/* at 0x240: r w	*/
extern volatile unsigned char	piab_p2da;	/* at 0x241: r w	*/
extern volatile unsigned char	piab_pda;	/* at 0x242: r w	*/
extern volatile unsigned char	piab_pdb;	/* at 0x243: r w	*/
extern volatile unsigned char	piab_pdc;	/* at 0x244: r w	*/
extern volatile unsigned char	piab_ddra;	/* at 0x246: r w	*/
extern volatile unsigned char	piab_ddrb;	/* at 0x247: r w	*/
extern volatile unsigned char	piab_ddrc;	/* at 0x248: r w	*/
extern volatile unsigned char	piab_cra;	/* at 0x249: r w	*/
extern volatile unsigned char	piab_crb;	/* at 0x24a: r w	*/
extern volatile unsigned char	piab_fsr;	/* at 0x24b: r w	*/
extern volatile unsigned char	piab_p1db;	/* at 0x24c: r w	*/
extern volatile unsigned char	piab_p2db;	/* at 0x24d: r w	*/
extern volatile unsigned char	piab_hsr;	/* at 0x24e: r w	*/
extern volatile unsigned char	piab_hwr;	/* at 0x24f: r w	*/


/************************************************/
/* Bit definitions for OASIS I/O		*/
/************************************************/
/* Bits for oasis_ctrl			*/
#define EXTEN		0x01		/* External Enable		    */
#define RXSEL		0x02		/* Select TTL (vs RS232) for ser rcv*/
#define RS232DSBL	0x04		/* Shutdown bit for RS232 drvrs	    */
#define RS485EN		0x08		/* Enable bit for RS485 drvr	    */
#define ANALOG_DSBL	0x10		/* Disable +8 analog power	    */
#define UART_CLK	0x20		/* Enable bit for UART clocks	    */
#define UARTA_INT	0x40		/* Enable UARTA Tx Interrupt	    */
#define UARTB_INT	0x80		/* Enable UARTB Tx Interrupt	    */

/* Definitions of Port 1 Bits		*/
#define RTC_CLK		0x01		/* Serial clk for RTC is on P1.0    */
#define RTC_SO		0x02		/* RTC serial in is on P1.1	    */
#define RTC_SI		0x04		/* RTC serial out is on P1.2	    */
#define RTC_SEL		0x20		/* RTC select is on P1.5	    */
#define RTC_OUT		(RTC_CLK | RTC_SO | RTC_SEL)
					/* Output bits for RTC		    */
#define PWM1		0x08		/* PWM1 bit on P1.3		    */
#define PWM2		0x10		/* PWM2 bit on P1.4		    */

/* Definitions of Port 2 Bits		*/
#define TXDBIT		1		/* TxD is on P2.0		    */
#define EXTINT_BIT	4		/* Ext Int is on P2.2		    */
#define EXTWAKE_BIT	0x40		/* Ext Wake signal on P2.6 (T2UD)   */

/* 82C52 UART Definitions		*/
#define UART_NO_PTY	0x0e		/* UCR bits for no parity	    */
#define UART_EVEN_PTY	0		/* UCR bits for even parity	    */
#define UART_ODD_PTY	0x02		/* UCR bits for odd parity	    */
#define UART_7BIT	0x020		/* UCR bits for 7 bit characters    */
#define UART_8BIT	0x030		/* UCR bits for 8 bit characters    */
#define UART_1STOP	0		/* UCR bits for 1 stop bit	    */
#define UART_2STOP	1		/* UCR bits for 2 stop bits	    */

#define RTS		0x01		/* RTS ctrl bit in MCR		    */
#define DTR		0x02		/* DTR ctrl bit in MCR		    */
#define UART_INTEN	0x04		/* Int enbl bit in MCR		    */
#define UART_BRK	0x08		/* Send break bits in MCR	    */
#define UART_RCVEN	0x20		/* Receive enbl bit in MCR	    */
#define UART_MDMINT	0x40		/* Modem int enbl bit in MCR	    */
#define PTY_ERR		0x01		/* Parity error bit in MSR	    */
#define FRAME_ERR	0x02		/* Framing error bit in MSR	    */
#define OVERRUN		0x04		/* Overrun error bit in MSR	    */
#define BREAK		0x08		/* Break received bit in MSR	    */
#define STS_CHANGE	0x10		/* Modem status changed bit in MSR  */
#define XMIT_DONE	0x20		/* Transmission complete bit in MSR */
#define XMIT_RDY	0x40		/* Transmit buffer empty bit in MSR */
#define RCV_RDY		0x80		/* Received data ready bit in MSR   */

/* 6823 PIA Bit Definitions		*/
#define PIA_CR_NOHS	0x12		/* Init to CRA, CRB for no handshake*/
#define PIA_FSR_NOHS	0x00		/* Init to FSR for no handshake	    */
#define PWR_STROBE	1		/* PIA A port B bit strobes pwr ctrl*/


/************************************************/
/* 80C196 Definitions				*/
/* Things that aren't in 80c196.h, but should be*/
/************************************************/
/* Interrupt Mask/Pending Bits		*/
#define TIMER_OVF	0x01		/* IMASK Timer overflow		    */
#define AD_DONE		0x02		/* IMASK A/D Done 		    */
#define HSI		0x04		/* IMASK HSI Data 		    */
#define HSO		0x08		/* IMASK HSO 			    */
#define HSI0		0x10		/* IMASK HSI.0 Pin		    */
#define SW_TIMER	0x20		/* IMASK Software timer		    */
#define SER_INT		0x40		/* IMASK Serial port		    */
#define P07		0x80		/* IMASK External Int (8096 compat) */
#define XMIT		0x01		/* IMASK1 Serial Xmit		    */
#define RCV		0x02		/* IMASK1 Serial Received Data      */
#define HSI4		0x04		/* IMASK1 HSI half full		    */
#define T2_CAP		0x08		/* IMASK1 T2 Capture		    */
#define T2_OVF		0x10		/* IMASK1 T2 Overflow		    */
#define EXT_INT		0x20		/* IMASK1 External Int pin	    */
#define FIFO_FULL	0x40		/* IMASK1 HSI FIFO full		    */
#define NMI		0x80		/* IMASK1 NMI			    */

/* HSI Status Bits			*/
#define SWT0		0x01		/* SW Timer 0			    */
#define SWT1		0x02		/* SW Timer 1			    */
#define SWT2		0x04		/* SW Timer 2			    */
#define SWT3		0x08		/* SW Timer 3			    */
#define HSI_T2OVF	0x10		/* Timer 2 Overflow		    */
#define HSI_T1OVF	0x20		/* Timer 1 Overflow		    */
#define HSI_FIFOFULL	0x40		/* FIFO Full			    */
#define HSI_DATARDY	0x80		/* HSI Data Ready		    */

/* HSO Command Register			*/
/* Lower 4 bits identifies channel	*/
#define HSO_SW_TIMER(n)	(8 + n)		/* 0x08 - 0x0B for timers 0 - 3	    */
#define HSO_RESET_TMR2	0x0e		/* Reset timer 2		    */
#define HSO_ATOD	0x0f		/* Start A/D conversion		    */
#define HSO_INT		0x10		/* Generate int on HSO done	    */
#define HSO_SET		0x20		/* Set HSO line if 1, else clear    */
#define HSO_T2		0x40		/* User timer 2 if set, else timer 1*/
#define HSO_CAMLOCK	0x80		/* Lock entry in CAM		    */

/* CPU Serial Port Register bits	*/
#define SER_MODE(n)	(n & 3)		/* SPCON: 2 serial mode bits	    */
#define SER_PEN		0x04		/* SPCON: Enable even parity	    */
#define SER_REN		0x08		/* SPCON: Enable receiver	    */
#define SER_9BIT	0x10		/* SPCON: Set 9th bit of data	    */
#define SER_OE		0x04		/* SPSTAT: Overrun error	    */
#define SER_TXE		0x08		/* SPSTAT: Transmitter empty	    */
#define SER_FE		0x10		/* SPSTAT: Framing error	    */
#define SER_TI		0x20		/* SPSTAT: Transmitter ready int    */
#define SER_RI		0x40		/* SPSTAT: Received char int        */
#define SER_RB8		0x80		/* SPSTAT: Rcv parity err or 9th bit*/

/* A/D Converter			*/
#define AD_CHAN(x)	(x & 7)		/* Chan nmbr 3 LSBs for cmd, result */
#define AD_GO		0x08		/* Start A/D now (if 0, start w/HSO)*/
#define AD_NRDY		0x08		/* ADRESULT: A/D in progress	    */

/* IOC bytes				*/
#define IOC0		0x01		/* HSI.0 enbl, 1-3 disbl	    */
#define IOC1		0xa0		/* HSI, TXD			    */
#define IOC1_BRK	(IOC1 & ~0x20)	/* No TxD			    */
#define IOC2		0x90		/* Clr CAM, slow A/D clk	    */

/* IOS0 bits				*/
#define HSO_BIT(n)	(1 << n)	/* HSO.n current state		    */
#define HSO_FULL	0x40		/* HSO CAM or holding reg full	    */
#define HSO_HRFULL	0x80		/* HSO holding reg full		    */

/* IOS1 bits				*/
#define SWT(n)		(1 << n)	/* Software Timer 0 - 3		    */
#define HSI_T2OVF	0x10		/* Timer 2 Overflow		    */
#define HSI_T1OVF	0x20		/* Timer 1 Overflow		    */
#define HSI_FIFOFULL	0x40		/* FIFO Full			    */
#define HSI_DATARDY	0x80		/* HSI Data Ready		    */

/* IOS2 bits				*/
#define HSO_EVENT(n)	(1 << n)	/* HSO.n event occurred		    */
#define HSO_T2RST	0x40		/* Timer 2 reset event		    */
#define HSO_ADSTART	0x80		/* A/D Conversion started	    */

#endif	/* INCioh */
