/****************************************************************************/
/* Copyright 1999 MBARI                                                     */
/****************************************************************************/
/* $Header: hobi.h,v 4.5 2001/10/17 10:34:26 oasisa Exp $			    */
/* Summary  : Header file for HobiLabs Instrument Drivers		    */
/* Filename : hobi.c							    */
/* Author   : Kent Headley (klh)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.5 $							    */
/* Created  : 03/28/01							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 03jun01 klh - created						    */
/* $Log:	hobi.h,v $
 * Revision 4.5  2001/10/17  10:34:26  10:34:26  oasisa (Oasis users)
 * updated with new HRij channel data types
 * 
 * Revision 4.4  2001/06/19  12:14:06  12:14:06  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:43:54  11:43:54  oasisa (Oasis users)
 * Initial revision
 * 
*/
/****************************************************************************/

#ifndef INChobih
#define INChobih        1

#define HS2_RECORD_SIZE 62 /* size of HS2 ASCII D record */

/*
   For ARGOS, HS2 data is extracted from an HS2 D record (ASCII string) 
   and stored as binary bytes in a buffer as follows:
    S1:buf[0:1]
    S2:buf[2:3]
    S3:buf[4:5]
    G1:buf[6:6 upper nibble]
    G2:buf[6:6 lower nibble]
    G3:buf[7:7 lower nibble]
    TR:buf[8:8]
*/
#define HS2BUF_SIZE 10 /* (9) word-aligned */
#define AOS_SNORM1 10 /* offset in raw data string */
#define BOS_SNORM1 0  /* offset in binary buffer */
#define AOS_SNORM2 14 
#define BOS_SNORM2 2
#define AOS_SNORM3 18 
#define BOS_SNORM3 4
#define AOS_GAIN1 42
#define BOS_GAIN1 6
#define AOS_GAIN2 43 
#define BOS_GAIN2 6
#define AOS_GAIN3 44 
#define BOS_GAIN3 7
#define AOS_TEMPRAW 54 
#define BOS_TEMPRAW 8

/* Instrument inclusion masks for HydroDAS driver */
#define fAB   0x0000
#define fCB   0x0001
#define fHS2  0x0002
#define fHR41 0x0004
#define fHR42 0x0008
#define fHR43 0x0010
#define fHR44 0x0020
#define fHR21 0x0040
#define fHR22 0x0080

#endif /*INChobih*/
