/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: gps10.h,v 4.4 2001/06/19 12:13:57 oasisa Exp $			    */
/* Summary  : Definitions for the Magellan 10 channel GPS board		    */
/* Filename : gps10.h							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 03/30/95							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 30mar95 rah - created						    */
/* $Log:	gps10.h,v $
 * Revision 4.4  2001/06/19  12:13:57  12:13:57  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:43:42  11:43:42  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.3  99/06/16  10:21:27  10:21:27  bobh (Bob Herlien)
 * Mar/May '99 Deployments of M3/M2
 * 
 * Revision 3.5  96/07/17  13:01:15  13:01:15  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
 * Revision 3.4  96/06/18  15:24:07  15:24:07  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.2  95/04/11  14:03:31  14:03:31  hebo (Bob Herlien)
 * Drifter Deployment on IronEx
 * 
 * 
*/
/****************************************************************************/

#ifndef INCgps10h
#define INCgps10h	1

/****************************************/
/* Structures for position and logging	*/
/****************************************/

typedef struct				/************************************/
{					/* One GPS position/velocity sample */
    Int32	gps_lat;		/* Units of 10^-7 degrees North	    */
    Int32	gps_long;		/* Units of 10^-7 degrees East	    */
} GpsSample;				/************************************/

typedef struct				/************************************/
{					/* GPSRec - GPS Position record	    */
    Int32	gps_lat;		/* Units of 10^-7 degrees North	    */
    Int32	gps_long;		/* Units of 10^-7 degrees East	    */
    Nat32	gps_pos_err;		/* Variance of position (meters^2)  */
    Nat16	gps_samples;		/* Number of samples		    */
    Nat16	gps_ontime;		/* Time to get GPS samples	    */
    Word	gps_status;		/* Status word			    */
} GpsRec;				/************************************/

/********************************/
/* Misceallaneous defines	*/
/********************************/

#define GPS_SAMPLES	300		/* Max number GPS samples to take   */
#define GPS_CLK_UPDATE	3		/* Update clock if off > this # secs*/
#define GPS_ALMANAC_TIME (30 * 60)	/* Try 30 minutes for almanac if init*/
#define GPS_ALMANAC_AGE 3		/* Get almanac if over 3 weeks old  */
#define GPS_BUFSIZE	max(128, sizeof(GpsMsg))
					/* Buffer size for GPS messages	    */
#define LATLONG_ERR	LONG_MAX	/* Indicates bad GPSsample	    */
#define LATLONG_DIV	90  /* One unit of latitude (10^-7 degrees) equals  */
			    /* 1/90 meter (1.1 cm).  True also for longitude*/
			    /*only at equator, but we're approximating	    */
#define GPS_ERR_THRESH	25		/* Allow sample as good if < 10m off*/
					/* We compare variance, is squared  */

/************************************/
					/* GPS Message types		    */
#define SETUP_MSG		1	/* Message types TO Magellan receiver*/
#define MSG_REQUEST_MSG		2
#define INIT_POSITION_MSG	3
#define INIT_TIME_MSG		4
#define ALTITUDE_MSG		5
#define RESTART_MSG		6
					/* Msg types FROM GPS rcvr are also */
#define POSITION_MSG		0x81	/*  rtn codes from getAndCheckGpsMsg*/
#define TIME_MSG		0x82
#define SAT_STATUS_MSG		0x83
#define GENERAL_STATUS_MSG	0x84

					/************************************/
					/* Driver flags used by GPS driver  */
#define GPS_IN_USE	0x80		/* GPS already in use		    */
#define GPS_TRACKING	0x40		/* GPS getting good fixes	    */
					/************************************/
					/* Receiver modes in general sts msg*/
#define TRACKING2D	3		/* Getting 2D fixes		    */
#define TRACKING3D	4		/* Getting 3D fixes		    */
#define NOT_TRACKING	8		/* Not getting fixes		    */
					/************************************/


/************************************************/
/* Structures for messages from GPS Receiver	*/
/************************************************/

typedef struct				/************************************/
{					/* GpsMsgHdr - GPS Message Header   */
    Byte	msgSyncChr[2];		/* Sync chars of "$$"		    */
    Nat16	msgLen;			/* Message length		    */
} GpsMsgHdr;				/************************************/


/********************************/
/* Messages TO GPS Receiver	*/
/********************************/

typedef struct				/************************************/
{					/* GpsSetupMsg			    */
    Byte	setupType;		/* Message type 1		    */
    Byte	setupSubtype;		/* Subtype, 0 if permanent, 1 if non*/
    Byte	msgRates[4];		/* Output message rates, seconds    */
    Nat16	pdopCutoff;		/* PDOP above which 2D position used*/
    Byte	maskAngle;		/* Elevation angle mask, degrees    */
    Byte	signalLevel;		/* Min signal used for nav, 0 - 255 */
    Byte	velAvgTime;		/* Velocity averaging time, seconds */
    Int8	localGmtOffset;		/* Offset from GMT, units of 15 mins*/
    Byte	positionFmt;		/* Position format (see manual)	    */
    Byte	positionDatum;		/* Position datum (see manual)	    */
    Byte	velocityFmt;		/* Velocity format (see manual)	    */
    Byte	velocityUnits;		/* Velocity units (see manual)	    */
    Byte	positionMode;		/* Mode: Auto, 2D, or 3D	    */
    Byte	setupFlags;		/* Flags (see manual)		    */
    Byte	msgTrailer[2];		/* Chksum, \n; inserted by xmit func*/
} GpsSetupMsg;				/************************************/

typedef struct				/************************************/
{					/* GpsMsgRequest		    */
    Byte	msgType;		/* Message type 2		    */
    Byte	msgSubtype;		/* Subtype 0			    */
    Byte	reqType;		/* Type of message requested	    */
    Byte	reqSubtype;		/* Subtype of message requested	    */
    Byte	msgTrailer[2];		/* Chksum, \n; inserted by xmit func*/
} GpsMsgRequest;			/************************************/

typedef struct				/************************************/
{					/* GpsInitPosition		    */
    Byte	initType;		/* Message type 3		    */
    Byte	initSubtype;		/* Subtype 0 for lat, long, alt(m)  */
    Int32	initLat;		/* Init latitude, 10^-7 degrees N   */
    Int32	initLong;		/* Init longitude, 10^-7 degrees E  */
    Int32	initAlt;		/* Init altitude, meters	    */
    Byte	msgTrailer[2];		/* Chksum, \n; inserted by xmit func*/
} GpsInitPosition;			/************************************/

typedef struct				/************************************/
{					/* GpsInitTime			    */
    Byte	timeType;		/* Message type 4		    */
    Byte	timeSubtype;		/* Subtype 0			    */
    Nat16	initYear;		/* Current year			    */
    Byte	initMonth;		/* Current month		    */
    Byte	initDay;		/* Current day			    */
    Byte	initHour;		/* Current hour			    */
    Byte	initMinute;		/* Current minute		    */
    Byte	initSecond;		/* Current second		    */
    Byte	initFiller;		/* Filler, unused		    */
    Byte	msgTrailer[2];		/* Chksum, \n; inserted by xmit func*/
} GpsInitTime;				/************************************/

typedef struct				/************************************/
{					/* GpsAltitude			    */
    Byte	altType;		/* Message type 5		    */
    Byte	altSubtype;		/* Subtype 0 for meters		    */
    Int16	gpsAlt;			/* Current altitude, meters	    */
    Byte	msgTrailer[2];		/* Chksum, \n; inserted by xmit func*/
} GpsAltitude;				/************************************/


/********************************/
/* Messages FROM GPS Receiver	*/
/********************************/

typedef struct				/************************************/
{					/* GpsPosition			    */
    Byte	posType;		/* Message type 81		    */
    Byte	posSubtype;		/* Subtypes 00 - 74, we use 10	    */
    Byte	posStatus;		/* See manual			    */
    Byte	posPad;			/* Alignment filler		    */
    Nat32	posTime;		/* Milliseconds since start of week */
    Int32	posLat;			/* Units of 10^-7 degrees North	    */
    Int32	posLong;		/* Units of 10^-7 degrees East	    */
    Int32	posAlt;			/* Meters altitude		    */
    Int16	velocityNorth;		/* Km/hr north velocity		    */
    Int16	velocityEast;		/* Km/hr east velocity		    */
    Int16	velocityDown;		/* Km/hr downward velocity	    */
    Nat16	posPDOP;		/* PDOP of fix, units of 0.01	    */
    Nat16	posHDOP;		/* HDOP of fix, units of 0.01	    */
    Nat16	posVDOP;		/* VDOP of fix, units of 0.01	    */
    Nat16	posError;		/* Estimated error of fix, meters   */
    Byte	satsUsed;		/* Number of satellites used	    */
    Byte	satPRNs[10];		/* PRNs of satellites used	    */
    Byte	msgTrailer[2];		/* Chksum, \n			    */
} GpsPosition;				/************************************/

typedef struct				/************************************/
{					/* GpsTime			    */
    Byte	timeType;		/* Message type 82		    */
    Byte	timeSubtype;		/* Subtype 01 for UTC, 02 for local */
    Nat16	timeYear;		/* Current year			    */
    Byte	timeMonth;		/* Current month		    */
    Byte	timeDay;		/* Current day			    */
    Byte	timeHour;		/* Current hour			    */
    Byte	timeMinute;		/* Current minute		    */
    Byte	timeSecond;		/* Current second		    */
    Byte	timeFlags;		/* See manual			    */
    Byte	msgTrailer[2];		/* Chksum, \n			    */
} GpsTime;				/************************************/

typedef struct				/************************************/
{					/* Receiver/satellite status	    */
    Byte	satStsType;		/* Message type 83		    */
    Byte	satStsSubtype;		/* Subtype 00			    */
    Byte	satHealtyBits[4];	/* 32 bits, set if sat is healthy   */
    Byte	numSatsAboveMask;	/* Number healthy sats above el mask*/
    Byte	numSatsTracked;		/* Number satellites being tracked  */
    struct				/* Channel status, one for each chan*/
    {					/*				    */
	Byte	chanSts;		/* What channel is doing, see manual*/
	Byte	chanPRN;		/* PRN of satellite being tracked   */
	Byte	signalLevel;		/* Signal level, 0 - 255	    */
	Byte	elevation;		/* Elevation angle of satellite	    */
	Byte	azimuth;		/* Azimuth of satellite		    */
	Byte	svAccuracy;		/* ??				    */
    } chanStatus[10];			/* One for each rcvr channel	    */
    Byte	msgTrailer[2];		/* Chksum, \n			    */
} GpsSatStatus;				/************************************/

typedef struct				/************************************/
{					/* General receiver status	    */
    Byte	genStsType;		/* Message type 84		    */
    Byte	genStsSubtype;		/* Subtype 00			    */
    Byte	softwareVersion[2];	/* Major, minor version numbers	    */
    Nat16	almanacAge;		/* Almanac age in weeks		    */
    Byte	rcvrMode;		/* Receiver mode (see manual)	    */
    Byte	rcvrFlags;		/* See manual			    */
    Int16	txcoOffset;		/* Hz at L Band			    */
    Byte	msgTrailer[2];		/* Chksum, \n			    */
} GpsGeneralStatus;			/************************************/


/************************/
/* GPS Message Union	*/
/************************/

typedef union				/************************************/
{					/* Union of all Magellan message types*/
    GpsSetupMsg		setupMsg;	/* Setup message to rcvr	    */
    GpsMsgRequest	requestMsg;	/* Mesage request message to rcvr   */
    GpsInitPosition	initPosition;	/* Init position message to rcvr    */
    GpsInitTime		initTime;	/* Init time message to rcvr	    */
    GpsAltitude		altitudeMsg;	/* Altitude message to rcvr	    */
    GpsPosition		positionMsg;	/* Position/velocity msg from rcvr  */
    GpsTime		timeMsg;	/* Time message from rcvr	    */
    GpsSatStatus	satStatus;	/* Satellite status msg from rcvr   */
    GpsGeneralStatus	generalStatus;	/* General status message from rcvr */
} GpsMsg;				/************************************/

#endif /* INCgps10h */
