/****************************************************************************/
/* Copyright 1998 MBARI                                                     */
/****************************************************************************/
/* $Header: gndflt.c,v 4.4 2001/06/19 12:13:49 oasisa Exp $			    */
/* Summary  : Driver Routines for Ground Fault detection via serial analog  */
/* Filename : gndflt.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 06/01/98							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 1jun98 rah - created							    */
/* $Log:	gndflt.c,v $
 * Revision 4.4  2001/06/19  12:13:49  12:13:49  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:43:36  11:43:36  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.2  98/09/09  10:48:13  10:48:13  bobh (Bob Herlien)
 * Sept/Oct '98 deployments of M1, Eqpac 1 & 2
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <task.h>			/* OASIS Multitasking definitions   */

#define NUM_SAMPLES		3
#define WORDS_PER_SAMPLE	2
#define BYTES_PER_SAMPLE	(WORDS_PER_SAMPLE * sizeof(Nat16))
#define GF_SETUP_TIME		TICKS_PER_SECOND


/********************************/
/*	External Functions	*/
/********************************/

Void		drv_ser_port( Driver *dp );
Void		drv_ser_release( Driver *dp );
Void		drv_pwroff( Driver *dp );
Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );
Extern Void	xputc( Int16 c );
Extern Void	xputs( const char *s );
Extern Int16	xgetn_tmout( char *s, Int16 len, Nat16 tmout );
Extern Void	xflush_ser( Nat16 timeout );
Extern Void	bzero( void *s, int n );


/************************************************************************/
/* Function    : getGf							*/
/* Purpose     : Get One Ground Fault sample				*/
/* Inputs      : Drvr ptr, Digital I/O bits to output, place for result	*/
/* Outputs     : None							*/
/* Side Effects: Fill in result with 4 bytes, insert ff's if error	*/
/************************************************************************/
	Void
getGf( Driver *dp, Nat16 outputBits, Nat16 *resultp )
{
    Nat16	tries;

    for( tries = 0; tries < dp->drv_parms[PARM0]; tries++ )
    {
	xputs("!0SO");
	xputc( outputBits );
	xflush_ser( GF_SETUP_TIME );
	xputs("!0RA\1");

	if ( xgetn_tmout((char *)resultp, BYTES_PER_SAMPLE,
			 dp->drv_parms[TIMEOUT]) == BYTES_PER_SAMPLE )
	    return;
    }

    *resultp++ = 0xffff;
    *resultp = 0xffff;

} /* getGf() */


/************************************************************************/
/* Function    : gf_drv							*/
/* Purpose     : Ground Fault System driver				*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
gf_drv( Driver *dp )
{
    Nat16	results[NUM_SAMPLES * WORDS_PER_SAMPLE];
    
    drv_ser_port( dp );
    task_delay( TICKS_PER_SECOND );

    getGf( dp, 0, results );
    getGf( dp, 1, &results[WORDS_PER_SAMPLE] );
    getGf( dp, 3, &results[2*WORDS_PER_SAMPLE] );
    
    drv_ser_release( dp );
    drv_pwroff( dp );
    drvLog( dp, (Byte *)results, sizeof(results) );

} /* gf_drv() */
