/****************************************************************************/
/* Copyright (C) 2001 MBARI                                                 */
/* Author:                                                                  */
/****************************************************************************/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/************************************************************************/
/* Function    : xflush_ser						*/
/* Purpose     : Discard serial input stream				*/
/* Inputs      : Number of ticks to wait for input to flush		*/
/* Output      : None							*/
/* Comments    : If tmout == 0, just discard current input		*/
/************************************************************************/
	Void
xflush_ser( Nat16 tmout )
{
    Reg Nat16	chrs;

    if ( tmout )
	task_delay( tmout );

    ser_flush( port );

} /* xflush_ser() */
