/****************************************************************************/
/* Copyright 1991 MBARI                                                     */
/****************************************************************************/
/* $Header: drvr.h,v 4.4 2001/06/19 12:13:28 oasisa Exp $			    */
/* Summary  : Default Driver Table for OASIS Mooring Controller		    */
/* Filename : drvr.h							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 08/21/92							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 21aug92 rah - split from drvr.c, to support different configurations	    */
/* 10mar95 rah - drvr.{m1a,m1b,m2} archived separately from drvr.h	    */
/****************************************************************************/

#ifndef INCdrvrh
#define INCdrvrh	1

#define NUM_DRVRS	(sizeof(drv_default)/sizeof(DrvDesc))

/********************************/
/*	External Functions	*/
/********************************/

Extern Void	analog_drv(Driver *dp);		/* A/D driver		    */
Extern Void	argos_drv(Driver *dp);		/* ARGOS PTT driver routine */
Extern Void	gf_drv(Driver *dp); 		/* Driver for Ground Fault  */
Extern Void	microcat_drv(Driver *dp);	/* microCat CTD driver	    */
Extern Void	pco2_drv(Driver *dp);		/* pCO2 driver routine	    */
Extern MBool	pco2_wake(Driver *, MBool);	/* pCO2 wakeup routine	    */
Extern Void	specprr_drv(Driver *dp);	/* PRR Spectro driver	    */
Extern Void	hobi_drv(Driver *dp);		/* Hobi Instrument driver   */
Extern Void	isus_drv(Driver *dp);		/* ISUS NO3 driver	    */
Extern MBool	isus_wake(Driver *, MBool,char *);	/* ISUS wakeup routine	    */
Extern Void	runShutter(Driver *dp);		/* Spectro Shutter driver   */
Extern Void	usr_drv(Driver *dp);		/* User I/F driver routine  */
Extern MBool	null_func(Void);		/* Null function, rtns TRUE */
#ifdef DISK
Extern Void	disk_drv(Driver *dp);		/* Driver to monitor disk   */
#endif
#ifdef LOGGER
Extern Void	log_drv(Driver *dp);		/* Dummy data logger	    */
#endif


/****************************************/
/*	Default Driver Headers		*/
/****************************************/

#define U384N81		(BAUD_38400 | NO_PTY   | BIT8 | STOP1 | FLOW)
#define U192N81		(BAUD_19200 | NO_PTY   | BIT8 | STOP1 | FLOW)
#define U96N81NF	(BAUD_9600 | NO_PTY   | BIT8 | STOP1)
#define U96N81		(BAUD_9600 | NO_PTY   | BIT8 | STOP1 | FLOW)
#define U96E71		(BAUD_9600 | EVEN_PTY | BIT7 | STOP1 | FLOW)
#define U12N81		(BAUD_1200 | NO_PTY   | BIT8 | STOP1 | FLOW)
#define U12N81NF	(BAUD_1200 | NO_PTY   | BIT8 | STOP1)
#define U3N72NF		(BAUD_300 | NO_PTY   | BIT7 | STOP2)

#define DAYMASK		0x0e07
/* Mask to turn off sampling from 1800 to 0600 hours local	*/
/* Drivers in patch space
*/

const DrvDesc drv_default[] = 
{ 
  { "SpecPRR", specprr_drv, null_func,
    900, UARTA, U96N81NF, 0x00a4, 0x0082, 0x0001, SPEC_PRR, DAYMASK, 5, 4, 20, 20},
  { "Shutter0", runShutter, null_func,
    0, NO_SERIAL, 0, 0, 0, 0x0400, SHUTTER0, 0, 20, 0, 500, 5 },
  { "CTD", microcat_drv, null_func,
    900, UARTA, U96N81NF, 0x0068, 0x0082, 0x0002, MICROCAT, 0, 3, 10, 0, 0},
  { "pCO2", pco2_drv, pco2_wake,
    10800, UARTB, U3N72NF, 0x2900, 0xaa00, 0x0010, PCO2, 0, 5, 180, 120, 0x20},
  { "ISUS", isus_drv, isus_wake,
    5400, UARTB, U96N81NF, 0x2600, 0xaa00, 0x0004, ISUS, 0X7FF, 3, 5, 0, 0},
  { "HS2", hobi_drv, null_func,
    900, UARTA, U96N81NF, 0x00a8, 0x0081, 0x0100, HOBI_HS2, 0, 3, 10, 0, 0},
  { "HR3", hobi_drv, null_func,
    900, UARTA, U96N81NF, 0x00a8, 0x0081, 0x0100, HOBI_HR3, 0, 3, 10, 3, 0},
  { "Wetstar", analog_drv, null_func,
    900, NO_SERIAL, 0, 0, 0, 0x0040, FLUOR, 0, 10, 0, 1, 100},
  { "GF", gf_drv, null_func,
    1800, UARTA, U96N81NF, 0x00a8, 0x0042, 0x0800, GNDFAULT, 0, 3, 5, 0, 0},
  { "OASIS", analog_drv, null_func,
    1800, NO_SERIAL, 0, 0, 0, 0, OASIS_CAN, 0, 3, 2, 5, 100},
  { "ARGOS", argos_drv, null_func,
    55, UARTB, U12N81NF, 0x1a00, 0xaa00, 0, LOG_EMPTY, 0x0cfc, 3, 5, 2, 2},
#ifdef DISK
  { "Disk", disk_drv, null_func,
    0, NO_SERIAL, 0, 0, 0, 0, LOG_COMMENT, 0, 15, 0, 0, 0},
#endif
#ifdef LOGGER
  { "Logger", log_drv, null_func,
    0, NO_SERIAL, 0, 0, 0, 0, LOG_COMMENT, 0, 1, 1000, 0, 0},
#endif
  { "UserIF", usr_drv, null_func,
    43200, CPU_SER, (U192N81 | ECHO | AUTOCR), 0x8001, 0, 0, LOG_EMPTY, 0,
    120, 0, 0, 0}
};

#endif /* INCdrvrh */
