/************************************************************************/
/* Copyright 1991 MBARI							*/
/************************************************************************/
/* $Header: custom.h,v 4.4 2001/06/19 12:13:09 oasisa Exp $			*/
/* Summary  : Definition of customized parameters for OASIS		*/
/* Filename : custom.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 08/21/92							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 21aug92 rah - created						*/
/* $Log:	custom.h,v $
 * Revision 4.4  2001/06/19  12:13:09  12:13:09  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:42:54  11:42:54  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.1  98/05/12  09:35:04  09:35:04  bobh (Bob Herlien)
 * June '98 turnaround for EqPac
 * 
 * Revision 3.9  97/10/28  13:59:42  13:59:42  bobh (Bob Herlien)
 * EqPac Deployment of Nov 1997
 * 
 * Revision 3.5  96/07/17  13:01:20  13:01:20  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
 * Revision 3.4  96/06/18  15:24:49  15:24:49  bobh (Bob Herlien)
 * June '96 deployment of M1
 *
 * Revision 3.3  95/04/13  13:50:11  13:50:11  hebo (Bob Herlien)
 * Drifter Deployment for Coop (flip) cruise
 *
 * Revision 3.2  95/04/11  14:03:42  14:03:42  hebo (Bob Herlien)
 * Drifter Deployment on IronEx
 *
 * Revision 3.0  95/02/21  18:42:36  18:42:36  hebo (Bob Herlien)
 * February '95 Deployment
 * 
*/
/************************************************************************/

#ifndef INCcustomh
#define INCcustomh	1

/* Oasis Hardware Configuration */
#define WATCHDOG			/* Use watchdog timer		    */
#define ROCKY				/* Rocky extension board used	    */
#define PWR_PERM	0x0000		/* permanently powered instrs	    */


/* Oasis Software Configuration */
#define SYNC_AT_MIDNIGHT		/* Sync drvrs at 0000 local	    */
#define LO_MBARI (-8)
#define LO_EP1   (-10)
#define LO_EP2   (-11)
#define LOCAL_OFFSET	LO_EP1		/* Hours offset of local time vs GMT*/
#ifdef MAXLOGSIZE
#undef MAXLOGSIZE
#endif
#define MAXLOGSIZE	1536		/* Max size of log record	    */
#define LOG_STATUS	0		/* Log on/off status		    */

/* Device Configuration */
#undef  TNC				/* Using TNC radio link		    */
#define TNC_NAME	"2001EP1"	/* TNC Name for Packet radio	    */

#define PUMP_SYNC_CO2	"pCO2pump"	/* Name of pump to sync to	    */
#define CALCO2 			      	/* Auto calibrate pCO2              */
#define CAL_INTERVAL    23              /* Calibration sample interval,     */
					/* hours (CO2_ADJUSTCAL defined) or */
					/* samples */
#define PCO2_CAL_DELAY	20		/* Time to wait for calibration sample*/

/*#define CTD_TS	TRUE*/		/* TRUE for isolated CTD (TS cmd)   */
/*#define PUMP_SYNC_CTD	"CTDpump"*/	/* Name of pump driver to sync to   */

#define SHUTTER		1		/* One shutter on PRR		    */
#define SHUTTER_SYNC0	"Shutter0"	/* Name of shutter driver to sync to*/
#define SHUTTER0_ANALOG_PORT 0x7        /* A/D Port number */

#undef  RADIO				/* Do radio timeout & restart	    */
#define DFLT_XOFF_TMOUT 120		/* Seconds to wait for XON	    */
#define DFLT_SYNC_TMOUT 300		/* Seconds to wait for drvSync	    */

#define DISK				/* Disk drive included		    */

#define ARGOS				/* Sending data via ARGOS	    */
#define ARGOS_BIT	0x01		/* Argos wakeup Bit		    */
#ifdef ARGOS
#define NUM_ARGOS_BUFS	10		/* Number of ARGOS buffers	    */
#define ARGOS_ISUS
#define ARGOS_HR3
#define ARGOS_HS2
#undef ARGOS_AC9
#define ARGOS_PCO2
#undef ARGOS_GASHOUND
#define ARGOS_CTD
#define ARGOS_OSMO
#define ARGOS_SPECPRR
#define ARGOS_SHUTTER
#endif

#define ATLAS_BIT	0x10		/* ATLAS wakeup Bit		    */

#define GARMIN12_OLD     11
#define GARMIN12_FULL    12
#define GARMIN12_SMALL   8
#define GARMIN12_TINY    7
#define MAGELLAN10_FULL  10
#define MAGELLAN10_SMALL 9
#define MAGELLAN5_SMALL  5
#define GPS_BIT		0x20		/* GPS wakeup Bit		    */
#define GPS_TYPE	GARMIN12_SMALL	/* Garmin 12 chan, short version    */
#define GPS_LAT		(3645)		/* Set initial GPS Lat/Long	    */
#define GPS_LONG	(-12201)
#define GPS_ALT		(-26)


/* Test, Debug, Size Optimizations */
#define INCLUDE_SHUTCAL			/* Include shutter calibration func */
#define REDUCE_STRINGS			/* Use short strings                */
#define BLINKY				/* blinking LED                     */
#define FULL_SIGNON			/* display TNC at sign-on           */
#undef  ALLOW_PERM_WAKE			/* wakebits always on (gps test)    */
#define TINYSHUT			/* use reduced shutter code         */
#undef YMODEM	                        /* Implement YModem protocol        */
#ifdef YMODEM
#define YMODEM_FILENAME "ep1."          /* File name for YModem transfer    */
#define YMODEM_NAMESIZE  4              /* Size of file name                */
#endif
#undef LOGGER				/* Writes lots of log records       */



#endif	/* INCcustomh */
