/****************************************************************************/
/* Copyright 2001 MBARI                                                     */
/****************************************************************************/
/* $Header $*/
/* Summary  : Shared Driver Routines CTD, Tstring on OASIS mooring	    */
/* Filename : ctdcommon.c						    */
/* Author   : Kent Headley (klh)					    */
/* Project  : OASIS Mooring						    */
/* $Revision $  							    */
/* Created  : 08/03/2001 from ctd.c					    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 03Aug2001 klh - created from ctd.c    	       			    */
/* $Log:	ctdsh.c,v $
 * Revision 1.1  2001/10/17  10:27:17  10:27:17  oasisa (Oasis users)
 * Initial revision
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <custom.h>			/* CTD_TS definition		    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <stdio.h>			/* Standard I/O functions	    */

/********************************/
/*	External Functions	*/
/********************************/
Extern Int16	xgetc_tmout( Nat16 tmout );

/************************************************************************/
/* Function    : getCtdPrompt						*/
/* Purpose     : Look for CTD prompt					*/
/* Inputs      : Timeout in seconds					*/
/* Outputs     : OK or ERROR						*/
/************************************************************************/
	Int16
getCtdPrompt( Nat16 timeout )
{
    Reg Int16	c;
    Int16	i;
    
    for (i = 10; i && ((c = xgetc_tmout(timeout)) != ERROR); i--)
	if ( c == '>' )			/* Look for prompt		*/
	    return( OK );		/* If got it, return OK		*/

    return( ERROR );			/* If timed out, return ERROR	*/

} /* getCtdPrompt() */

