/****************************************************************************/
/* Copyright 1996 MBARI                                                     */
/****************************************************************************/
/* $Header: co2pump.c,v 4.4 2001/06/19 12:12:47 oasisa Exp $		    */
/* Summary  : Driver Routines for Air Pump for pCO2 sensor		    */
/* Filename : co2pump.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 06/13/96							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 13jun96 rah - created						    */
/* $Log:	co2pump.c,v $
 * Revision 4.4  2001/06/19  12:12:47  12:12:47  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:42:46  11:42:46  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.8  97/09/12  10:50:53  10:50:53  bobh (Bob Herlien)
 * Redeploy M1
 * 
 * Revision 3.7  97/07/23  11:18:11  11:18:11  bobh (Bob Herlien)
 * July '97 M1 deployment, new shutter code
 * 
 * Revision 3.5  96/07/17  13:01:29  13:01:29  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <string.h>			/* string functions		    */
#include <task.h>			/* OASIS Multitasking definitions   */


/********************************/
/*	External Functions	*/
/********************************/

Extern Void	drv_pwron( Driver *dp );
Extern Void	drv_pwroff( Driver *dp );
Extern Void	io_pwron( Word pwrbits );
Extern Void	io_pwroff( Word pwrbits );
Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );


/************************************************************************/
/* Function    : pco2pump_drv						*/
/* Purpose     : pCO2 Pump driver					*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
pco2pump_drv( Driver *dp )
{
    Byte	logByte;

    logByte = 1;
    drvLog( dp, &logByte, 1 );

    drv_pwron( dp );			  /* Turn on pco2 air pump	*/
    io_pwron( dp->drv_parms[PARM0] );	  /* Turn on water pump		*/
    delay_secs( dp->drv_parms[TIMEOUT] ); /* Wait for flush time	*/

    io_pwroff( dp->drv_parms[PARM0] );	  /* Turn off water pump	*/
    dp->drv_flags &= ~DO_SYNC;		  /* Notify waiting routines	*/

    delay_secs( dp->drv_parms[PARM1] );	  /* Let run for remaining time	*/
    drv_pwroff( dp );			  /* Turn off pump		*/

    logByte = 0;
    drvLog( dp, &logByte, 1 );

} /* pco2pump_drv() */
