/************************************************************************/
/* Copyright 1996 MBARI							*/
/************************************************************************/
/* $Header: argos.h,v 4.4 2001/06/19 12:12:23 oasisa Exp $			*/
/* Summary  : Definitions for ARGOS messages				*/
/* Filename : argos.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 06/28/96							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 28jun96 rah, created							*/
/* $Log:	argos.h,v $
 * Revision 4.4  2001/06/19  12:12:23  12:12:23  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:42:26  11:42:26  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.2  98/09/09  10:47:56  10:47:56  bobh (Bob Herlien)
 * Sept/Oct '98 deployments of M1, Eqpac 1 & 2
 * 
 * Revision 4.1  98/05/12  09:35:01  09:35:01  bobh (Bob Herlien)
 * June '98 turnaround for EqPac
 * 
 * Revision 4.0  98/03/09  11:44:34  11:44:34  bobh (Bob Herlien)
 * M3 Deployment of March '98, new Sat-Pac driver
 * 
 * Revision 3.9  97/10/28  13:59:39  13:59:39  bobh (Bob Herlien)
 * EqPac Deployment of Nov 1997
 * 
 * Revision 3.6  96/10/30  13:59:58  13:59:58  bobh (Bob Herlien)
 * Release for EqPac, M2 Test Replacement
 * 
 * Revision 3.5  96/07/17  13:01:17  13:01:17  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
*/
/************************************************************************/

#ifndef INCargosh
#define INCargosh		1

#define	ARGOS_LEN		32	/* Length of ARGOS data		    */
#define	ARGOS_WORDS	(ARGOS_LEN/2)	/* Length of data in words	    */

#define	CHEM_SIZE		12	/* 12 bits * 8 samples = 12 bytes   */
#define	CH_UNUSED_SIZE	         7	/* Size of unused chem buffer       */
#define NO3_SIZE		12	/* 12 bits * 8 samples = 12 bytes   */
#define SPEC_CHANS		 7	/* Number of channels of spectro data*/
#define FLUOR_SIZE		12	/* 12 bits * 8 samples = 12 bytes   */
#define FLUOR20_WORDS		 6	/* 00, 06, 09, 12, 15, 1750 hours   */
#ifndef NUM_ARGOS_BUFS
#define NUM_ARGOS_BUFS	10		/* Number of ARGOS buffers	    */
#endif

/* This is Rev 4 of the ARGOS message type definitions			    */
/* Rev 1 - Uses Rev 1&2 message types, messages had simple checksum	    */
/* Rev 2 - Same messages as Rev 1 but renumbered, messages had CRC	    */
/* Rev 3 - Delete AC-9, include Dark and shutter messages (as rev 3 below)  */
/* Rev 4 - Delete NO3, substitute PRR parms, add 10th msg type for Satlantic*/
/* Rev 5 - Del prr pitch,roll; Del MCP; Del 12:30 prr T,D; change 12:30 to  */
/*         10:00; Del 12:30 SAT Lu; Add ISUS; Add HS2			    */

#define ARGOS_REV 5
/****************************************/
/* ARGOS Message Buffer Identifiers	*/
/****************************************/

#if ( ARGOS_REV == 5 )
#define CHEM		0		/* pCO2 and NO3 buffer		    */
#define SPEC_0M_NOON	1		/* Surface Spectro, noon sample	    */
#define SPEC_0M_1000	2		/* Surface Spectro, 1230 PM sample  */
#define MISC		3		/* Misc data buffer		    */
#define SPEC_20M_NOON	4		/* 20 meter Spectro, noon sample    */
#define SPEC_20M_1000	5		/* 20 meter Spectro, noon sample    */
#define SHUTTR		6		/* Shutter/Errors/Satlantic Dark    */
#define SPEC_0M_DARK	7		/* Surface Spectro Dark values	    */
#define SPEC_20M_DARK	8		/* 20 meter Spectro Dark values	    */
#define SAT1		9		/* Satlantic 1 message		    */


/****************************************/
/* ARGOS Message Buffer Types		*/
/****************************************/

typedef struct				/************************************/
{					/* Chemical Buffer - pCO2 & NO3     */
    Word	ch_type;		/* Message type and checksum	    */
    Byte	ch_pco2[CHEM_SIZE];	/* pCO2 samples			    */
    Nat16	ch_prr_temp;		/* Temp from noon 20m PRR sample    */
    Nat16	ch_prr_depth;		/* Depth from noon 20m PRR sample   */
    Nat16	ch_unused[CH_UNUSED_SIZE];		/* Unused			    */
} ChemMsg;				/************************************/

typedef struct				/************************************/
{					/* Spectral Data Buffer		    */
    Word	sp_type;		/* Message type and checksum	    */
    Nat16	sp_ed[SPEC_CHANS];	/* Downwelling (incident) channels  */
    Nat16	sp_lu[SPEC_CHANS];	/* Upwelling (reflected) channels   */
    Nat16	sp_misc;		/* Misc (error or chan cnt)	    */
} SpecMsg;				/************************************/

typedef struct				/************************************/
{					/* Miscellaneous Message Buffer     */
    Word	ms_type;		/* Message type and checksum	    */
    Nat16	ms_pco2;		/* pCO2 calibration and sample time */
    Nat32	ms_oasis;		/* OASIS batt, temp, ARGOS batt	    */
    Byte	fl_0m[FLUOR_SIZE];	/* Surface Wetstar samples	    */
    Nat16	fl_20m[FLUOR20_WORDS];	/* 20m Wetstar samples		    */
} MiscMsg;				/************************************/

typedef struct				/************************************/
{					/* Shutter Message		    */
    Word	sh_type;		/* Message type and checksum	    */
    Nat16	sh_attempts;		/* Total attempts		    */
    Byte	sh_opens;		/* Total open operations	    */
    Byte	sh_closes;		/* Total close operations	    */
    Byte	sh_toterrs;		/* Non-zero returns		    */
    Byte	sh_errs[3];		/* Errors by type		    */
    Word	sh_oasisErrs;		/* OASIS error flags		    */
    Nat16	sh_sat1Dark[SPEC_CHANS]; /* Dark Satlantic 1 values	    */
    Nat16	sh_ctd_temp;		/* Noon CTD Temperature		    */
    Nat16	sh_ctd_cond;		/* Noon CTD Conductivity	    */
    Nat16	sh_fill;		/* Unused			    */
} ShutterMsg;				/************************************/

typedef struct				/************************************/
{					/* General ARGOS message buffer	    */
    Word	ag_type;		/* Type MSB 4 bits, CRC-12 12 bits  */
    Nat16	ag_data[ARGOS_WORDS-1];	/* Data				    */
} ArgosMsg;				/************************************/

typedef struct				/************************************/
{					/* All ARGOS Message buffers	    */
    ChemMsg	chem;			/* Chemistry buffer		    */
    SpecMsg	spec0m;			/* Noon surface spectral buffer	    */
    SpecMsg	spec0m_1000;		/* 1230 PM surface spectral buffer  */
    MiscMsg	misc;			/* Miscellaneous buffer		    */
    SpecMsg	spec20m;		/* Noon 20 meter spectral buffer    */
    SpecMsg	spec20m_1000;		/* 1230 PM 20 meter spectral buffer */
    ShutterMsg	shutter;		/* Shutter message		    */
    SpecMsg	spec0mDark;		/* Midnight Surface spectral buffer */
    SpecMsg	spec20mDark;		/* Midnight 20 meter spectral buffer*/
    SpecMsg	sat1;			/* Satlantic 1 noon and 1230 buffer */
} ArgosStruct;				/************************************/

typedef union				/************************************/
{					/* Union of Argos message buffers   */
    ArgosStruct	arg_struct;		/* Structure of types		    */
    ArgosMsg	arg_data[NUM_ARGOS_BUFS];/* Plain data types		    */
} ArgosUnion;				/************************************/
#endif

#endif	/* INCargosh */
