;****************************************************************************
;* Copyright 1996 MBARI							    *
;****************************************************************************
;* $Header  : ac9s.s,v 3.2 95/04/11 14:03:38 hebo Exp $			    *
;* Summary  : Assembly language routines for AC-9 absorption meter	    *
;* Filename : ac9s.s							    *
;* Author   : Robert Herlien						    *
;* Project  : OASIS Mooring Controller                                      *
;* $Revision: 4.4 $							    *
;* Created  : 04/26/96                                                      *
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;****************************************************************************
;
AC9S		MODULE
;
$INCLUDE(..\C196\INCLUDE\8096.INC)
$INCLUDE(OASIS.INC)
;

AC9_CHANS	equ	18
AC9_DATA_OFFSET	equ	14
AC9_SAMPLES	equ	10


;*****************************************************************************
;  Scratch registers for process_ac9_pkt
;
		RSEG

ac9_cntr:	dsw	1


		CSEG

PUBLIC	ac9_chksum			;Routine to calc checksum on buffer
PUBLIC	process_ac9_pkt			;Add raw ac9 packet into running total


;*****************************************************************************
; ac9_chksum - Calculate checksum on buffer
;
; Nat16 ac9_chksum( Byte *p, Nat16 len )
;
;	Approx 4.5 usecs/byte
;
ac9_chksum:
	ld	tmp0, #01feh		;Init checksum
	ld	tmp2, 2[SP]		;Point to buffer
	ld	tmp4, 4[SP]		;Get length to checksum over
ac9_chksum1:
	ldbze	tmp6, [tmp2]+		;Get buffer byte
	add	tmp0, tmp6		;Add to checksum
	djnzw	tmp4, ac9_chksum1	;Repeat until done
	ret


;*****************************************************************************
; process_one_ac9_record - Process one data or reference record for AC-9
;
; Inputs: tmp2 = Raw Data pointer
;	  tmp4 = Processed Data pointer
;

process_one_ac9_record:
	ld	tmp6, #AC9_CHANS
process_one_loop:
	ldb	tmp0, 2[tmp2]
	ldb	tmp0 + 1, [tmp2]
	add	tmp0, [tmp4]
	st	tmp0, [tmp4]+
	ldbze	tmp0, 1[tmp2]
	addc	tmp0, [tmp4]
	st	tmp0, [tmp4]+
	add	tmp2, #3
	djnzw	tmp6, process_one_loop
	ret


;*****************************************************************************
; process_ac9_pkt - Add AC-9 Packet into running total
;
; Void	process_ac9_pkt( Ac9Raw *bufp, Ac9Data *datap );
;

process_ac9_pkt:
	ld	ac9_cntr, #AC9_SAMPLES
	ld	tmp2, 2[SP]
	add	tmp2, #AC9_DATA_OFFSET
ac9_loop:
	add	tmp2, #2			;Skip sample time field
	ld	tmp4, 4[SP]
	scall	process_one_ac9_record		;Add sample records
	djnzw	ac9_cntr, ac9_loop

	scall	process_one_ac9_record		;Add reference records
	ld	tmp0, [tmp2]			;Add temperture field
	add	tmp0, [tmp4]
	st	tmp0, [tmp4]+
	ld	tmp0, [tmp4]
	addc	tmp0, R0
	st	tmp0, [tmp4]
	ret


	END
