/****************************************************************************/
/* Copyright 1996 MBARI                                                     */
/****************************************************************************/
/* $Header: ac9.h,v 4.4 2001/06/19 12:11:37 oasisa Exp $			    */
/* Summary  : Definitions for AC-9 transmittance/absorbance meter	    */
/* Filename : ac9.h							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 07/03/96 from ac9.c					    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 02jul96 rah - created from ac9.c					    */
/* $Log:	ac9.h,v $
 * Revision 4.4  2001/06/19  12:11:37  12:11:37  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:41:50  11:41:50  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.5  96/07/17  13:01:16  13:01:16  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
*/
/****************************************************************************/

#ifndef INCac9h
#define INCac9h		1

#define AC9_BUFLEN	640		/* Actually 634, but leave some room*/
					/* Caution - must be < MAXLOGSIZE   */
#define AC9_CHANS	18		/* Number of channels		    */
#define CHL_CHAN	1		/* Chlorophyll channel		    */

typedef struct				/************************************/
{					/* One AC-9 sample for one channel  */
    Byte	ac9_mid;		/* Middle data byte		    */
    Byte	ac9_hi;			/* High data byte		    */
    Byte	ac9_lo;			/* Low data byte		    */
} Ac9RawSample;				/************************************/

typedef struct				/************************************/
{					/* Struct for one data sample of AC-9*/
    Int16	 ac9_time;		/* Time of sample (unused here)	    */	
    Ac9RawSample ac9_raw[AC9_CHANS];	/* Data samples			    */
} Ac9RawRecord;				/************************************/

typedef struct				/************************************/
{					/* Raw data struct for AC-9	    */
    Nat16	 ac9_len;		/* Length of message		    */
    Byte	 ac9_unused1[12];	/* Serial number, etc		    */
    Ac9RawRecord ac9_data[10];		/* Sample data			    */
    Ac9RawSample ac9_ref[AC9_CHANS];	/* Reference data		    */
    Nat16	 ac9_temp;		/* Temperature			    */
    Nat16	 ac9_chksum;		/* Checksum			    */
} Ac9Raw;				/************************************/

typedef union				/************************************/
{					/* Struct for AC-9 raw data buffer  */
    Ac9Raw	ac9_raw;		/* Raw data struct as above	    */
    Byte	ac9_bytes[AC9_BUFLEN];	/* As a byte buffer		    */
} Ac9Buffer;				/************************************/

typedef struct				/************************************/
{					/* Struct to accumulate AC-9 Data   */
    Nat32	ac9_data[AC9_CHANS];	/* Sample data			    */
    Nat32	ac9_ref[AC9_CHANS];	/* Reference data		    */
    Nat32	ac9_temp;		/* Temperature			    */
    Nat16	ac9_samples;		/* Number of samples taken	    */
} Ac9Data;				/************************************/

typedef struct				/************************************/
{					/* Struct to Pass data to ARGOS drvr*/
    Nat16	ac9_result[AC9_CHANS];	/* Sample/reference for each chan   */
    Nat16	ac9_temp;		/* Averaged Temperature		    */
} Ac9Result;				/************************************/

#endif	/* INCac9h */
