/*
 * Decompiled with CFR 0.152.
 */
package lcm.spy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import lcm.lcm.LCM;
import lcm.lcm.LCMDataInputStream;
import lcm.lcm.LCMSubscriber;
import lcm.spy.ChannelData;
import lcm.spy.ChartData;
import lcm.spy.LCMTypeDatabase;
import lcm.spy.ObjectPanel;
import lcm.spy.SpyPlugin;
import lcm.util.ClassDiscoverer;
import lcm.util.TableSorter;

public class Spy {
    LCM lcm;
    LCMTypeDatabase handlers;
    long startuTime;
    HashMap<String, ChannelData> channelMap = new HashMap();
    ArrayList<ChannelData> channelList = new ArrayList();
    ChannelTableModel _channelTableModel = new ChannelTableModel();
    TableSorter channelTableModel = new TableSorter(this._channelTableModel);
    JTable channelTable = new JTable(this.channelTableModel);
    ChartData chartData;
    ArrayList<SpyPlugin> plugins = new ArrayList();
    JButton clearButton = new JButton("Clear");

    public Spy(String string) throws IOException {
        this.channelTableModel.setTableHeader(this.channelTable.getTableHeader());
        this.channelTableModel.setSortingStatus(0, 1);
        this.handlers = new LCMTypeDatabase();
        TableColumnModel tableColumnModel = this.channelTable.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(140);
        tableColumnModel.getColumn(1).setMinWidth(140);
        tableColumnModel.getColumn(2).setMaxWidth(100);
        tableColumnModel.getColumn(3).setMaxWidth(100);
        tableColumnModel.getColumn(4).setMaxWidth(100);
        tableColumnModel.getColumn(5).setMaxWidth(100);
        tableColumnModel.getColumn(6).setMaxWidth(100);
        JFrame jFrame = new JFrame("LCM Spy");
        jFrame.setLayout(new BorderLayout());
        jFrame.add((Component)this.channelTable.getTableHeader(), "First");
        jFrame.add((Component)this.clearButton, "South");
        jFrame.add((Component)new JScrollPane(this.channelTable), "Center");
        this.chartData = new ChartData(Spy.utime_now());
        jFrame.setSize(800, 600);
        jFrame.setLocationByPlatform(true);
        jFrame.setVisible(true);
        this.lcm = null == string ? new LCM(new String[0]) : new LCM(string);
        this.lcm.subscribeAll(new MySubscriber());
        new HzThread().start();
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Spy.this.channelMap.clear();
                Spy.this.channelList.clear();
                Spy.this.channelTableModel.fireTableDataChanged();
            }
        });
        this.channelTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiersEx();
                if (mouseEvent.getButton() == 3) {
                    Spy.this.showPopupMenu(mouseEvent);
                } else if (mouseEvent.getClickCount() == 2) {
                    Point point = mouseEvent.getPoint();
                    int n2 = Spy.this.rowAtPoint(point);
                    ChannelData channelData = Spy.this.channelList.get(n2);
                    boolean bl = false;
                    for (SpyPlugin spyPlugin : Spy.this.plugins) {
                        if (bl || !spyPlugin.canHandle(channelData.fingerprint)) continue;
                        new PluginStarter(spyPlugin, channelData).getAction().actionPerformed(null);
                        bl = true;
                    }
                    if (!bl) {
                        Spy.this.createViewer(Spy.this.channelList.get(n2));
                    }
                }
            }
        });
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Spy quitting");
                System.exit(0);
            }
        });
        ClassDiscoverer.findClasses(new PluginClassVisitor());
        System.out.println("Found " + this.plugins.size() + " plugins");
        for (SpyPlugin spyPlugin : this.plugins) {
            System.out.println(" " + spyPlugin);
        }
    }

    void createViewer(ChannelData channelData) {
        if (channelData.viewerFrame != null && !channelData.viewerFrame.isVisible()) {
            channelData.viewerFrame.dispose();
            channelData.viewer = null;
        }
        if (channelData.viewer == null) {
            channelData.viewerFrame = new JFrame(channelData.name);
            channelData.viewer = new ObjectPanel(channelData.name, this.chartData);
            channelData.viewerFrame.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(channelData.viewer);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
            channelData.viewer.setViewport(jScrollPane.getViewport());
            channelData.viewerFrame.add((Component)jScrollPane, "Center");
            channelData.viewer.setObject(channelData.last, channelData.last_utime);
            channelData.viewerFrame.setSize(650, 400);
            channelData.viewerFrame.setLocationByPlatform(true);
            channelData.viewerFrame.setVisible(true);
        } else {
            channelData.viewerFrame.setVisible(true);
        }
    }

    static final long utime_now() {
        return System.nanoTime() / 1000L;
    }

    int rowAtPoint(Point point) {
        int n = this.channelTable.rowAtPoint(point);
        return this.channelTableModel.modelIndex(n);
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        ChannelData channelData = this.channelList.get(n);
        JPopupMenu jPopupMenu = new JPopupMenu("Viewers");
        int n2 = this.channelTable.rowAtPoint(point);
        this.channelTable.setRowSelectionInterval(n2, n2);
        jPopupMenu.add(new DefaultViewer(channelData));
        if (channelData.cls != null) {
            for (SpyPlugin spyPlugin : this.plugins) {
                if (!spyPlugin.canHandle(channelData.fingerprint)) continue;
                jPopupMenu.add(new PluginStarter(spyPlugin, channelData).getAction());
            }
        }
        jPopupMenu.show(this.channelTable, mouseEvent.getX(), mouseEvent.getY());
    }

    public static void usage() {
        System.err.println("usage: lcm-spy [options]");
        System.err.println("");
        System.err.println("lcm-spy is the Lightweight Communications and Marshalling traffic ");
        System.err.println("inspection utility.  It is a graphical tool for viewing messages received on ");
        System.err.println("an LCM network, and is analagous to tools like Ethereal/Wireshark and tcpdump");
        System.err.println("in that it is able to inspect all LCM messages received and provide information");
        System.err.println("and statistics on the channels used.");
        System.err.println("");
        System.err.println("When given appropriate LCM type definitions, lcm-spy is able to");
        System.err.println("automatically detect and decode messages, and can display the individual fields");
        System.err.println("of recognized messages.  lcm-spy is limited to displaying statistics for");
        System.err.println("unrecognized messages.");
        System.err.println("");
        System.err.println("Options:");
        System.err.println("  -l, --lcm-url=URL      Use the specified LCM URL");
        System.err.println("  -h, --help             Shows this help text and exits");
        System.err.println("");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (System.getProperty("java.vendor").indexOf("Free Software Foundation") >= 0) {
            System.err.println("WARNING: Detected gcj. lcm-spy is not known to work well with gcj.");
            System.err.println("         The Sun JRE is recommended.");
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-h") || string2.equals("--help")) {
                Spy.usage();
                continue;
            }
            if (string2.equals("-l") || string2.equals("--lcm-url") || string2.startsWith("--lcm-url=")) {
                String string3 = null;
                if (string2.startsWith("--lcm-url=")) {
                    string3 = string2.substring(10);
                } else if (i < stringArray.length) {
                    string3 = stringArray[++i];
                }
                if (null == string3) {
                    Spy.usage();
                    continue;
                }
                string = string3;
                continue;
            }
            Spy.usage();
        }
        try {
            new Spy(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    class DefaultViewer
    extends AbstractAction {
        ChannelData cd;

        public DefaultViewer(ChannelData channelData) {
            super("Structure Viewer...");
            this.cd = channelData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Spy.this.createViewer(this.cd);
        }
    }

    class HzThread
    extends Thread {
        public HzThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                long l = Spy.utime_now();
                ArrayList<ChannelData> arrayList = Spy.this.channelList;
                synchronized (arrayList) {
                    for (ChannelData channelData : Spy.this.channelList) {
                        long l2 = channelData.nreceived - channelData.hz_last_nreceived;
                        channelData.hz_last_nreceived = channelData.nreceived;
                        long l3 = l - channelData.hz_last_utime;
                        channelData.hz_last_utime = l;
                        channelData.hz = (double)l2 / ((double)l3 / 1000000.0);
                        channelData.min_interval = channelData.hz_min_interval;
                        channelData.max_interval = channelData.hz_max_interval;
                        channelData.hz_min_interval = 9999L;
                        channelData.hz_max_interval = 0L;
                        channelData.bandwidth = (double)channelData.hz_bytes / ((double)l3 / 1000000.0);
                        channelData.hz_bytes = 0L;
                    }
                }
                int n = Spy.this.channelTable.getSelectedRow();
                Spy.this.channelTableModel.fireTableDataChanged();
                if (n >= 0) {
                    Spy.this.channelTable.setRowSelectionInterval(n, n);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    class MySubscriber
    implements LCMSubscriber {
        MySubscriber() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(LCM lCM, String string, LCMDataInputStream lCMDataInputStream) {
            Object var4_4 = null;
            ChannelData channelData = Spy.this.channelMap.get(string);
            int n = 0;
            try {
                n = lCMDataInputStream.available();
                long l = n >= 8 ? lCMDataInputStream.readLong() : -1L;
                lCMDataInputStream.reset();
                Class clazz = Spy.this.handlers.getClassByFingerprint(l);
                if (channelData == null) {
                    channelData = new ChannelData();
                    channelData.name = string;
                    channelData.cls = clazz;
                    channelData.fingerprint = l;
                    channelData.row = Spy.this.channelList.size();
                    ArrayList<ChannelData> arrayList = Spy.this.channelList;
                    synchronized (arrayList) {
                        Spy.this.channelMap.put(string, channelData);
                        Spy.this.channelList.add(channelData);
                        Spy.this._channelTableModel.fireTableDataChanged();
                    }
                } else if (clazz != null && channelData.cls != null && !channelData.cls.equals(clazz)) {
                    System.out.println("WARNING: Class changed for channel " + string);
                    ++channelData.nerrors;
                }
                long l2 = Spy.utime_now();
                long l3 = l2 - channelData.last_utime;
                channelData.hz_min_interval = Math.min(channelData.hz_min_interval, l3);
                channelData.hz_max_interval = Math.max(channelData.hz_max_interval, l3);
                channelData.hz_bytes += (long)n;
                channelData.last_utime = l2;
                ++channelData.nreceived;
                var4_4 = channelData.cls.getConstructor(DataInput.class).newInstance(lCMDataInputStream);
                channelData.last = var4_4;
                if (channelData.viewer != null) {
                    channelData.viewer.setObject(var4_4, channelData.last_utime);
                }
            }
            catch (NullPointerException nullPointerException) {
                ++channelData.nerrors;
            }
            catch (IOException iOException) {
                ++channelData.nerrors;
                System.out.println("Spy.messageReceived ex: " + iOException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ++channelData.nerrors;
                System.out.println("Spy.messageReceived ex: " + noSuchMethodException);
            }
            catch (InstantiationException instantiationException) {
                ++channelData.nerrors;
                System.out.println("Spy.messageReceived ex: " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ++channelData.nerrors;
                System.out.println("Spy.messageReceived ex: " + illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ++channelData.nerrors;
            }
        }
    }

    class ChannelTableModel
    extends AbstractTableModel {
        ChannelTableModel() {
        }

        public int getColumnCount() {
            return 8;
        }

        public int getRowCount() {
            return Spy.this.channelList.size();
        }

        public Object getValueAt(int n, int n2) {
            ChannelData channelData = Spy.this.channelList.get(n);
            if (channelData == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return channelData.name;
                }
                case 1: {
                    if (channelData.cls == null) {
                        return String.format("?? %016x", channelData.fingerprint);
                    }
                    String string = channelData.cls.getName();
                    return string.substring(string.lastIndexOf(46) + 1);
                }
                case 2: {
                    return "" + channelData.nreceived;
                }
                case 3: {
                    return String.format("%6.2f", channelData.hz);
                }
                case 4: {
                    return String.format("%6.2f ms", 1000.0 / channelData.hz);
                }
                case 5: {
                    return String.format("%6.2f ms", (double)(channelData.max_interval - channelData.min_interval) / 1000.0);
                }
                case 6: {
                    return String.format("%6.2f KB/s", channelData.bandwidth / 1024.0);
                }
                case 7: {
                    return "" + channelData.nerrors;
                }
            }
            return "???";
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Channel";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Num Msgs";
                }
                case 3: {
                    return "Hz";
                }
                case 4: {
                    return "1/Hz";
                }
                case 5: {
                    return "Jitter";
                }
                case 6: {
                    return "Bandwidth";
                }
                case 7: {
                    return "Undecodable";
                }
            }
            return "???";
        }
    }

    class PluginClassVisitor
    implements ClassDiscoverer.ClassVisitor {
        PluginClassVisitor() {
        }

        public void classFound(String string, Class clazz) {
            Class<?>[] classArray;
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                if (!clazz2.equals(SpyPlugin.class)) continue;
                try {
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    SpyPlugin spyPlugin = (SpyPlugin)constructor.newInstance(new Object[0]);
                    Spy.this.plugins.add(spyPlugin);
                }
                catch (Exception exception) {
                    System.out.println("ex: " + exception);
                }
            }
        }
    }

    class PluginStarter {
        private SpyPlugin plugin;
        private ChannelData cd;
        private String name;

        public PluginStarter(SpyPlugin spyPlugin, ChannelData channelData) {
            this.plugin = spyPlugin;
            this.cd = channelData;
            Action action = this.plugin.getAction(null, null);
            this.name = (String)action.getValue("Name");
        }

        public Action getAction() {
            return new PluginStarterAction();
        }

        class PluginStarterAction
        extends AbstractAction {
            public PluginStarterAction() {
                super(PluginStarter.this.name);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame(((PluginStarter)PluginStarter.this).cd.name);
                jFrame.setLayout(new BorderLayout());
                JDesktopPane jDesktopPane = new JDesktopPane();
                jFrame.add(jDesktopPane);
                jFrame.setSize(500, 400);
                jFrame.setLocationByPlatform(true);
                jFrame.setVisible(true);
                PluginStarter.this.plugin.getAction(jDesktopPane, PluginStarter.this.cd).actionPerformed(null);
            }
        }
    }
}

