/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.util.HashMap;
import lcm.lcm.LCM;
import lcm.lcm.LCMDataInputStream;
import lcm.lcm.LCMDataOutputStream;
import lcm.lcm.Provider;
import lcm.lcm.URLParser;

public class UDPMulticastProvider
implements Provider {
    MulticastSocket sock;
    static final String DEFAULT_NETWORK = "239.255.76.67:7667";
    static final int DEFAULT_TTL = 0;
    static final int MAGIC_SHORT = 1279471666;
    static final int MAGIC_LONG = 1279471667;
    static final int FRAGMENTATION_THRESHOLD = 64000;
    ReaderThread reader;
    int msgSeqNumber = 0;
    HashMap<SocketAddress, FragmentBuffer> fragBufs = new HashMap();
    LCM lcm;
    InetAddress inetAddr;
    int inetPort;

    public UDPMulticastProvider(LCM lCM, URLParser uRLParser) throws IOException {
        this.lcm = lCM;
        String[] stringArray = uRLParser.get("network", DEFAULT_NETWORK).split(":");
        this.inetAddr = InetAddress.getByName(stringArray[0]);
        this.inetPort = Integer.valueOf(stringArray[1]);
        this.sock = new MulticastSocket(this.inetPort);
        this.sock.setReuseAddress(true);
        this.sock.setLoopbackMode(false);
        int n = uRLParser.get("ttl", 0);
        if (n == 0) {
            System.err.println("LCM: TTL set to zero, traffic will not leave localhost.");
        } else if (n > 1) {
            System.err.println("LCM: TTL set to > 1... That's almost never correct!");
        } else {
            System.err.println("LCM: TTL set to 1.");
        }
        this.sock.setTimeToLive(uRLParser.get("ttl", 0));
        this.sock.joinGroup(this.inetAddr);
    }

    public synchronized void publish(String string, byte[] byArray, int n, int n2) {
        try {
            this.publishEx(string, byArray, n, n2);
        }
        catch (Exception exception) {
            System.err.println("ex: " + exception);
        }
    }

    public synchronized void subscribe(String string) {
        if (null == this.reader) {
            this.reader = new ReaderThread();
            this.reader.start();
        }
    }

    public void unsubscribe(String string) {
    }

    public synchronized void close() {
        if (null != this.reader) {
            this.reader.interrupt();
            try {
                this.reader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.reader = null;
        this.sock.close();
        this.sock = null;
        this.fragBufs = null;
    }

    void publishEx(String string, byte[] byArray, int n, int n2) throws Exception {
        byte[] byArray2 = string.getBytes("US-ASCII");
        int n3 = byArray2.length + n2;
        if (n3 <= 64000) {
            LCMDataOutputStream lCMDataOutputStream = new LCMDataOutputStream(n2 + string.length() + 32);
            lCMDataOutputStream.writeInt(1279471666);
            lCMDataOutputStream.writeInt(this.msgSeqNumber);
            lCMDataOutputStream.writeStringZ(string);
            lCMDataOutputStream.write(byArray, n, n2);
            this.sock.send(new DatagramPacket(lCMDataOutputStream.getBuffer(), 0, lCMDataOutputStream.size(), this.inetAddr, this.inetPort));
        } else {
            int n4 = n3 / 64000;
            if (n3 % 64000 > 0) {
                ++n4;
            }
            if (n4 > 65535) {
                System.err.println("LC error: too much data for a single message");
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64010);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n5 = 0;
            int n6 = 0;
            dataOutputStream.writeInt(1279471667);
            dataOutputStream.writeInt(this.msgSeqNumber);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeShort(n6);
            dataOutputStream.writeShort(n4);
            dataOutputStream.write(byArray2, 0, byArray2.length);
            dataOutputStream.writeByte(0);
            int n7 = 64000 - (byArray2.length + 1);
            dataOutputStream.write(byArray, n, n7);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            this.sock.send(new DatagramPacket(byArray3, 0, byArray3.length, this.inetAddr, this.inetPort));
            n5 += n7;
            for (n6 = 1; n6 < n4; ++n6) {
                byteArrayOutputStream = new ByteArrayOutputStream(64010);
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(1279471667);
                dataOutputStream.writeInt(this.msgSeqNumber);
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeInt(n5);
                dataOutputStream.writeShort(n6);
                dataOutputStream.writeShort(n4);
                int n8 = Math.min(64000, n2 - n5);
                dataOutputStream.write(byArray, n + n5, n8);
                byArray3 = byteArrayOutputStream.toByteArray();
                this.sock.send(new DatagramPacket(byArray3, 0, byArray3.length, this.inetAddr, this.inetPort));
                n5 += n8;
            }
        }
        ++this.msgSeqNumber;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.err.println("LCM: Disabling IPV6 support");
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
            this.setDaemon(true);
        }

        public void run() {
            DatagramPacket datagramPacket = new DatagramPacket(new byte[65536], 65536);
            while (!this.isInterrupted()) {
                try {
                    UDPMulticastProvider.this.sock.receive(datagramPacket);
                    this.handlePacket(datagramPacket);
                }
                catch (IOException iOException) {
                    System.err.println("ex: " + iOException);
                }
            }
        }

        public void interrupt() {
            super.interrupt();
            UDPMulticastProvider.this.sock.close();
        }

        void handleShortMessage(DatagramPacket datagramPacket, LCMDataInputStream lCMDataInputStream) throws IOException {
            int n = lCMDataInputStream.readInt();
            String string = lCMDataInputStream.readStringZ();
            UDPMulticastProvider.this.lcm.receiveMessage(string, lCMDataInputStream.getBuffer(), lCMDataInputStream.getBufferOffset(), lCMDataInputStream.available());
        }

        void handleFragment(DatagramPacket datagramPacket, LCMDataInputStream lCMDataInputStream) throws IOException {
            int n = lCMDataInputStream.readInt();
            int n2 = lCMDataInputStream.readInt() & 0xFFFFFFFF;
            int n3 = lCMDataInputStream.readInt() & 0xFFFFFFFF;
            int n4 = lCMDataInputStream.readShort() & 0xFFFF;
            int n5 = lCMDataInputStream.readShort() & 0xFFFF;
            byte[] byArray = new byte[lCMDataInputStream.available()];
            lCMDataInputStream.readFully(byArray);
            if (lCMDataInputStream.available() > 0) {
                System.err.println("Unread data! " + lCMDataInputStream.available());
            }
            int n6 = 0;
            int n7 = byArray.length;
            SocketAddress socketAddress = datagramPacket.getSocketAddress();
            FragmentBuffer fragmentBuffer = UDPMulticastProvider.this.fragBufs.get(socketAddress);
            if (fragmentBuffer != null && (fragmentBuffer.msgSeqNumber != n || fragmentBuffer.data_size != n2)) {
                UDPMulticastProvider.this.fragBufs.remove(fragmentBuffer.from);
                fragmentBuffer = null;
            }
            if (null == fragmentBuffer && 0 == n4) {
                int n8;
                for (n8 = 0; n8 < byArray.length && 0 != byArray[n8]; ++n8) {
                }
                n6 = n8 + 1;
                n7 -= n8 + 1;
                String string = new String(byArray, 0, n8, "US-ASCII");
                fragmentBuffer = new FragmentBuffer(socketAddress, string, n, n2, n5);
                UDPMulticastProvider.this.fragBufs.put(fragmentBuffer.from, fragmentBuffer);
            }
            if (null == fragmentBuffer) {
                return;
            }
            if (n3 + n7 > fragmentBuffer.data_size) {
                System.err.println("LC: dropping invalid fragment");
                UDPMulticastProvider.this.fragBufs.remove(fragmentBuffer.from);
                return;
            }
            if (!fragmentBuffer.frag_received[n4]) {
                fragmentBuffer.frag_received[n4] = true;
                System.arraycopy(byArray, n6, fragmentBuffer.data, n3, n7);
                --fragmentBuffer.fragments_remaining;
            }
            if (0 == fragmentBuffer.fragments_remaining) {
                UDPMulticastProvider.this.lcm.receiveMessage(fragmentBuffer.channel, fragmentBuffer.data, 0, fragmentBuffer.data_size);
                UDPMulticastProvider.this.fragBufs.remove(fragmentBuffer.from);
            }
        }

        void handlePacket(DatagramPacket datagramPacket) throws IOException {
            LCMDataInputStream lCMDataInputStream = new LCMDataInputStream(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            int n = lCMDataInputStream.readInt();
            if (n == 1279471666) {
                this.handleShortMessage(datagramPacket, lCMDataInputStream);
            } else if (n == 1279471667) {
                this.handleFragment(datagramPacket, lCMDataInputStream);
            } else {
                System.err.println("bad magic: " + Integer.toHexString(n));
                return;
            }
        }
    }

    class FragmentBuffer {
        SocketAddress from = null;
        String channel = null;
        int msgSeqNumber = 0;
        int data_size = 0;
        int fragments_remaining = 0;
        byte[] data = null;
        boolean[] frag_received;

        FragmentBuffer(SocketAddress socketAddress, String string, int n, int n2, int n3) {
            this.from = socketAddress;
            this.channel = string;
            this.msgSeqNumber = n;
            this.data_size = n2;
            this.fragments_remaining = n3;
            this.data = new byte[n2];
            this.frag_received = new boolean[n3];
        }
    }
}

