/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.units;

import java.io.Serializable;

public abstract class AUnit
implements Serializable {
    private static final long serialVersionUID = -8890511971185813347L;
    protected int m_decimals = 2;
    protected double m_factor;
    protected AUnit m_nexLowerUnit;
    protected AUnit m_nextHigherUnit;
    protected String m_unitName;

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_decimals;
        long l = Double.doubleToLongBits(this.m_factor);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.m_unitName == null ? 0 : this.m_unitName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AUnit aUnit = (AUnit)object;
        if (this.m_decimals != aUnit.m_decimals) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_factor) != Double.doubleToLongBits(aUnit.m_factor)) {
            return false;
        }
        return !(this.m_unitName == null ? aUnit.m_unitName != null : !this.m_unitName.equals(aUnit.m_unitName));
    }

    protected AUnit() {
    }

    public int getDecimals() {
        return this.m_decimals;
    }

    public double getFactor() {
        return this.m_factor;
    }

    public String getLabel(double d) {
        return new StringBuffer().append(this.round(d / this.m_factor)).append(" ").append(this.m_unitName).toString();
    }

    public AUnit getNexLowerUnit() {
        return this.m_nexLowerUnit;
    }

    public AUnit getNextHigherUnit() {
        return this.m_nextHigherUnit;
    }

    public String getUnitName() {
        return this.m_unitName;
    }

    public double getValue(double d) {
        return this.round(d / this.m_factor);
    }

    private final double round(double d) {
        double d2 = Math.pow(10.0, this.m_decimals);
        return Math.floor(d * d2 + 0.5) / d2;
    }

    public void setDecimals(int n) {
        if (n >= 0) {
            this.m_decimals = n;
        }
    }

    public String toString() {
        return this.getUnitName();
    }
}

