/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.math;

public final class MathUtil {
    private static MathUtil instance = null;

    public static void assertDouble(double d) throws IllegalArgumentException {
        if (!MathUtil.isDouble(d)) {
            throw new IllegalArgumentException(d + " is not valid.");
        }
    }

    public static boolean assertEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static MathUtil getInstance() {
        if (instance == null) {
            instance = new MathUtil();
        }
        return instance;
    }

    public static Integer increment(Integer n) {
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        Integer n3 = n2 + 1;
        return n3;
    }

    public static boolean isDouble(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    private MathUtil() {
    }
}

