/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.math;

public class IntegerMutable {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    private int m_value;

    public IntegerMutable(int n) {
        this.m_value = n;
    }

    public void add(int n) throws ArithmeticException {
        int n2 = this.m_value;
        this.m_value += n;
        if (n2 > this.m_value) {
            this.m_value = n2;
            throw new ArithmeticException("Overflow detected. Value saved unchanged.");
        }
    }

    public void add(Integer n) throws ArithmeticException {
        this.add((int)n);
    }

    public void add(IntegerMutable integerMutable) throws ArithmeticException {
        this.add(integerMutable.getValue());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntegerMutable integerMutable = (IntegerMutable)object;
        return this.m_value == integerMutable.m_value;
    }

    public int getValue() {
        return this.m_value;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_value;
        return n;
    }

    public int intValue() {
        return this.m_value;
    }

    public void setValue(int n) {
        this.m_value = n;
    }

    public void sub(int n) throws ArithmeticException {
        int n2 = this.m_value;
        this.m_value -= n;
        if (n2 < this.m_value) {
            this.m_value = n2;
            throw new ArithmeticException("Carry detected. Value saved unchanged.");
        }
    }

    public void sub(Integer n) throws ArithmeticException {
        this.sub((int)n);
    }

    public void sub(IntegerMutable integerMutable) throws ArithmeticException {
        this.sub(integerMutable.intValue());
    }

    public String toString() {
        return String.valueOf(this.m_value);
    }
}

