/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.collections.IComparableProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSetGreedy<T extends IComparableProperty>
extends TreeSet<T>
implements Set<T> {
    private static final long serialVersionUID = 3258130237048173623L;

    private static Number createDecreasedNumber(Number number) {
        Number number2;
        Class<?> clazz = number.getClass();
        if (clazz == Integer.class) {
            number2 = new Integer(number.intValue() - 1);
        } else if (clazz == Double.class) {
            number2 = new Double(number.doubleValue() - 1.0);
        } else if (clazz == Float.class) {
            number2 = new Float(number.floatValue() - 1.0f);
        } else if (clazz == Short.class) {
            number2 = new Short((short)(number.shortValue() - 1));
        } else if (clazz == Byte.class) {
            number2 = new Byte((byte)(number.byteValue() - 1));
        } else if (clazz == Long.class) {
            number2 = new Long(number.longValue() - 1L);
        } else if (clazz == BigDecimal.class) {
            BigDecimal bigDecimal = new BigDecimal(number.toString());
            bigDecimal = bigDecimal.subtract(new BigDecimal(1));
            number2 = bigDecimal;
        } else {
            BigInteger bigInteger = new BigInteger(number.toString());
            bigInteger = bigInteger.subtract(new BigInteger("1"));
            number2 = bigInteger;
        }
        return number2;
    }

    public TreeSetGreedy() {
        super(new NumberPropertyComparator());
    }

    @Override
    public synchronized boolean add(T t) {
        boolean bl = this.addInternal(t);
        return bl;
    }

    private boolean addInternal(T t) {
        boolean bl;
        if (!this.isEmpty() && (bl = this.contains(t))) {
            IComparableProperty iComparableProperty = (IComparableProperty)this.first();
            t.setComparableProperty(TreeSetGreedy.createDecreasedNumber(iComparableProperty.getComparableProperty()));
        }
        bl = super.add(t);
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NumberPropertyComparator<T extends IComparableProperty>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 2279828650090806643L;

        @Override
        public int compare(T t, T t2) throws ClassCastException {
            double d;
            double d2;
            int n = t == t2 ? 0 : ((d2 = t.getComparableProperty().doubleValue()) < (d = t2.getComparableProperty().doubleValue()) ? -1 : (d2 == d ? 0 : 1));
            return n;
        }
    }
}

