/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.StringUtil;
import info.monitorenter.util.collections.IRingBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBufferArrayFast<T>
implements Cloneable,
IRingBuffer<T> {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = 3834590997991404595L;
    protected Object[] m_buffer;
    protected boolean m_empty = true;
    protected int m_headpointer = 0;
    protected int m_size;
    protected int m_tailpointer = 0;

    public RingBufferArrayFast(int n) {
        this.m_buffer = new Object[n];
        this.m_size = n - 1;
    }

    @Override
    public T add(T t) {
        Object object = null;
        if (this.isFull()) {
            object = this.m_buffer[this.m_tailpointer];
            this.incTail();
        }
        this.m_buffer[this.m_headpointer] = t;
        this.incHead();
        return (T)object;
    }

    @Override
    public void clear() {
        this.m_headpointer = 0;
        this.m_tailpointer = 0;
        this.m_empty = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RingBufferArrayFast ringBufferArrayFast = (RingBufferArrayFast)object;
        if (!Arrays.equals(this.m_buffer, ringBufferArrayFast.m_buffer)) {
            return false;
        }
        if (this.m_empty != ringBufferArrayFast.m_empty) {
            return false;
        }
        if (this.m_headpointer != ringBufferArrayFast.m_headpointer) {
            return false;
        }
        if (this.m_size != ringBufferArrayFast.m_size) {
            return false;
        }
        return this.m_tailpointer == ringBufferArrayFast.m_tailpointer;
    }

    @Override
    public int getBufferSize() {
        return this.m_size + 1;
    }

    @Override
    public T getOldest() throws IRingBuffer.RingBufferException {
        if (this.isEmpty()) {
            throw new IRingBuffer.RingBufferException("Buffer is empty.");
        }
        return (T)this.m_buffer[this.m_tailpointer];
    }

    @Override
    public T getYoungest() throws IRingBuffer.RingBufferException {
        if (this.isEmpty()) {
            throw new IRingBuffer.RingBufferException("Buffer is empty.");
        }
        int n = this.m_headpointer;
        n = n == 0 ? this.m_size : --n;
        return (T)this.m_buffer[n];
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.m_buffer);
        n = 31 * n + (this.m_empty ? 1231 : 1237);
        n = 31 * n + this.m_headpointer;
        n = 31 * n + this.m_size;
        n = 31 * n + this.m_tailpointer;
        return n;
    }

    private void incHead() {
        this.m_headpointer = this.m_headpointer == this.m_size ? 0 : ++this.m_headpointer;
        this.m_empty = false;
    }

    private void incTail() {
        this.m_tailpointer = this.m_tailpointer == this.m_size ? 0 : ++this.m_tailpointer;
        if (this.m_tailpointer == this.m_headpointer) {
            this.m_empty = true;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_empty;
    }

    @Override
    public boolean isFull() {
        boolean bl = this.m_headpointer == this.m_tailpointer && !this.m_empty;
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iteratorL2F();
    }

    @Override
    public Iterator<T> iteratorF2L() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArrayFast.this.m_headpointer == 0 ? RingBufferArrayFast.this.size() - 1 : RingBufferArrayFast.this.m_headpointer - 1;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == 0 ? RingBufferArrayFast.this.m_size : --this.m_pos;
            }
        };
    }

    @Override
    public Iterator<T> iteratorL2F() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArrayFast.this.m_tailpointer;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == RingBufferArrayFast.this.m_size ? 0 : ++this.m_pos;
            }
        };
    }

    @Override
    public T remove() {
        if (this.isEmpty()) {
            throw new IRingBuffer.RingBufferException("Buffer is empty.");
        }
        Object object = null;
        object = this.m_buffer[this.m_tailpointer];
        this.incTail();
        return (T)object;
    }

    @Override
    public T[] removeAll() {
        Object[] objectArray = new Object[this.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.remove();
        }
        return objectArray;
    }

    @Override
    public void setBufferSize(int n) {
        Object[] objectArray = new Object[n];
        boolean bl = this.m_empty;
        int n2 = 0;
        int n3 = this.size();
        int n4 = n3 - n;
        for (int i = 0; i < n4 && !this.isEmpty(); ++i) {
            this.remove();
        }
        for (n2 = 0; n2 < n && !this.isEmpty(); ++n2) {
            objectArray[n2] = this.remove();
        }
        this.m_tailpointer = 0;
        this.m_headpointer = n2;
        if (this.m_headpointer == n) {
            this.m_headpointer = 0;
        }
        this.m_buffer = objectArray;
        this.m_size = n - 1;
        this.m_empty = bl || n == 0;
    }

    @Override
    public int size() {
        int n = 0;
        n = this.m_empty ? 0 : (this.m_headpointer == this.m_tailpointer ? this.m_size + 1 : (this.m_headpointer > this.m_tailpointer ? this.m_headpointer - this.m_tailpointer : this.m_headpointer + this.m_size + 1 - this.m_tailpointer));
        return n;
    }

    public String toString() {
        String string;
        if (this.isEmpty()) {
            string = "[]";
        } else {
            Object[] objectArray = new Object[this.size()];
            int n = this.m_tailpointer;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.m_buffer[n];
                n = n == this.m_size ? 0 : ++n;
                if (n == this.m_headpointer && this.m_empty) break;
            }
            string = StringUtil.arrayToString(objectArray);
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ARingBufferIterator
    implements Iterator<T> {
        protected int m_count;
        protected int m_pos;

        ARingBufferIterator() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ARingBufferIterator aRingBufferIterator = (ARingBufferIterator)object;
            if (!this.getOuterType().equals(aRingBufferIterator.getOuterType())) {
                return false;
            }
            if (this.m_count != aRingBufferIterator.m_count) {
                return false;
            }
            return this.m_pos == aRingBufferIterator.m_pos;
        }

        private RingBufferArrayFast<T> getOuterType() {
            return RingBufferArrayFast.this;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.m_count;
            n = 31 * n + this.m_pos;
            return n;
        }

        @Override
        public boolean hasNext() {
            return this.m_count < RingBufferArrayFast.this.size();
        }

        protected abstract void incPos();

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = RingBufferArrayFast.this.m_buffer[this.m_pos];
            ++this.m_count;
            this.incPos();
            if (object == null) {
                throw new NoSuchElementException("RingBufferArrayFast.iteratorF2L returns null: pos:" + this.m_pos + " count: " + this.m_count);
            }
            return object;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

