/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.StringUtil;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBufferArray<T>
extends RingBufferArrayFast<T> {
    private static final long serialVersionUID = 3977861774055585593L;
    protected List<T> m_pendingremove = new LinkedList<T>();

    public RingBufferArray(int n) {
        super(n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RingBufferArray ringBufferArray = (RingBufferArray)object;
        return !(this.m_pendingremove == null ? ringBufferArray.m_pendingremove != null : !this.m_pendingremove.equals(ringBufferArray.m_pendingremove));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_pendingremove == null ? 0 : this.m_pendingremove.hashCode());
        return n;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.m_pendingremove.size() == 0;
    }

    @Override
    public Iterator<T> iteratorF2L() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArray.this.m_headpointer == 0 ? RingBufferArray.this.m_size : RingBufferArray.this.m_headpointer - 1;
                this.m_pendpos = RingBufferArray.this.m_pendingremove.size() - 1;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == 0 ? RingBufferArray.this.m_size : --this.m_pos;
            }
        };
    }

    @Override
    public Iterator<T> iteratorL2F() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArray.this.m_tailpointer;
                this.m_pendpos = 0;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == RingBufferArray.this.m_size ? 0 : ++this.m_pos;
            }
        };
    }

    @Override
    public T remove() {
        T t = null;
        t = this.m_pendingremove.size() > 0 ? (T)this.m_pendingremove.remove(0) : (T)super.remove();
        return t;
    }

    @Override
    public T[] removeAll() {
        int n;
        Object[] objectArray = new Object[this.size() + this.m_pendingremove.size()];
        int n2 = this.m_pendingremove.size();
        for (n = 0; n < n2; ++n) {
            objectArray[n] = this.m_pendingremove.remove(0);
        }
        while (n < objectArray.length) {
            objectArray[n] = this.remove();
            ++n;
        }
        return objectArray;
    }

    @Override
    public void setBufferSize(int n) {
        int n2;
        LinkedList<T> linkedList = null;
        if (this.size() > n) {
            linkedList = new LinkedList<T>();
            int n3 = this.size();
            for (n2 = n; n2 < n3; ++n2) {
                T t = this.remove();
                linkedList.add(t);
            }
        }
        Object[] objectArray = new Object[n];
        n2 = 0;
        while (!this.isEmpty()) {
            objectArray[n2] = this.remove();
            ++n2;
        }
        this.m_tailpointer = 0;
        this.m_headpointer = n == n2 ? 0 : n2;
        this.m_buffer = objectArray;
        this.m_size = n - 1;
        if (linkedList != null) {
            this.m_pendingremove = linkedList;
        }
    }

    @Override
    public int size() {
        return super.size() + this.m_pendingremove.size();
    }

    @Override
    public String toString() {
        String string;
        if (this.isEmpty()) {
            string = "[]";
        } else {
            int n;
            Object[] objectArray = new Object[this.size()];
            int n2 = this.m_tailpointer;
            int n3 = this.m_pendingremove.size();
            Iterator<T> iterator = this.m_pendingremove.iterator();
            for (n = 0; n < n3; ++n) {
                objectArray[n] = iterator.next();
            }
            while (n < objectArray.length) {
                objectArray[n] = this.m_buffer[n2];
                n2 = n2 == this.m_size ? 0 : ++n2;
                if (n2 == this.m_headpointer && this.m_empty) break;
                ++n;
            }
            string = StringUtil.arrayToString(objectArray);
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ARingBufferIterator
    extends RingBufferArrayFast.ARingBufferIterator {
        protected int m_pendpos;

        ARingBufferIterator() {
            super(RingBufferArray.this);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ARingBufferIterator aRingBufferIterator = (ARingBufferIterator)object;
            if (!this.getOuterType().equals(aRingBufferIterator.getOuterType())) {
                return false;
            }
            return this.m_pendpos == aRingBufferIterator.m_pendpos;
        }

        private RingBufferArray<T> getOuterType() {
            return RingBufferArray.this;
        }

        @Override
        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.m_pendpos;
            return n;
        }

        @Override
        public boolean hasNext() {
            return super.hasNext() || this.m_pendpos >= 0;
        }

        @Override
        protected void incPos() {
        }

        @Override
        public T next() {
            Object object = null;
            if (this.m_pendpos >= 0) {
                object = RingBufferArray.this.m_pendingremove.get(this.m_pendpos);
                --this.m_pendpos;
                if (object == null) {
                    System.out.println("RingBufferArray.iteratorF2L returns null: head:" + RingBufferArray.this.m_headpointer + " tail: " + RingBufferArray.this.m_tailpointer);
                }
            } else {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                object = RingBufferArray.this.m_buffer[this.m_pos];
                ++this.m_count;
                this.incPos();
            }
            return object;
        }
    }
}

