/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializationUtility {
    public static Stroke readStroke(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Stroke stroke = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            Class clazz = (Class)objectInputStream.readObject();
            if (clazz.equals(BasicStroke.class)) {
                float f = objectInputStream.readFloat();
                int n = objectInputStream.readInt();
                int n2 = objectInputStream.readInt();
                float f2 = objectInputStream.readFloat();
                float[] fArray = (float[])objectInputStream.readObject();
                float f3 = objectInputStream.readFloat();
                stroke = new BasicStroke(f, n, n2, f2, fArray, f3);
            } else {
                stroke = (Stroke)objectInputStream.readObject();
            }
        }
        return stroke;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream objectOutputStream) throws IOException {
        if (stroke != null) {
            objectOutputStream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)stroke;
                objectOutputStream.writeObject(BasicStroke.class);
                objectOutputStream.writeFloat(basicStroke.getLineWidth());
                objectOutputStream.writeInt(basicStroke.getEndCap());
                objectOutputStream.writeInt(basicStroke.getLineJoin());
                objectOutputStream.writeFloat(basicStroke.getMiterLimit());
                objectOutputStream.writeObject(basicStroke.getDashArray());
                objectOutputStream.writeFloat(basicStroke.getDashPhase());
            } else {
                objectOutputStream.writeObject(stroke.getClass());
                objectOutputStream.writeObject(stroke);
            }
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }

    private SerializationUtility() {
    }
}

