/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.util.math.MathUtil;
import java.io.Serializable;

public class Range
implements Serializable {
    public static final Range RANGE_UNBOUNDED = new Range(-1.7976931348623157E308, Double.MAX_VALUE);
    private static final long serialVersionUID = 3760565278089754419L;
    protected double m_max;
    protected double m_min;

    public Range(double d, double d2) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cannot work on Double.NaN for min.");
        }
        MathUtil.assertDouble(d);
        MathUtil.assertDouble(d2);
        if (d < d2) {
            this.m_min = d;
            this.m_max = d2;
        } else {
            this.m_min = d2;
            this.m_max = d;
        }
    }

    public boolean ensureContained(double d) {
        boolean bl = false;
        if (d < this.m_min) {
            bl = true;
            this.m_min = d;
        } else if (d > this.m_max) {
            bl = true;
            this.m_max = d;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Range range = (Range)object;
        if (Double.doubleToLongBits(this.m_max) != Double.doubleToLongBits(range.m_max)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_min) == Double.doubleToLongBits(range.m_min);
    }

    public double getExtent() {
        return this.m_max - this.m_min;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getMin() {
        return this.m_min;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m_max);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_min);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean isContained(double d) {
        return this.m_min <= d && this.m_max >= d;
    }

    public void mimic(Range range) {
        this.m_max = range.m_max;
        this.m_min = range.m_min;
    }

    public final void setMax(double d) {
        this.m_max = d;
    }

    public final void setMin(double d) {
        this.m_min = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Range[");
        stringBuffer.append(this.m_min).append(',');
        stringBuffer.append(this.m_max).append(']');
        return stringBuffer.toString();
    }
}

