/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.util.StringUtil;
import info.monitorenter.util.collections.Entry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private static final ResourceBundle m_bundle = ResourceBundle.getBundle("messages");

    public static Map.Entry<String, String> cutDirectoryInformation(URL uRL) {
        String string;
        String string2;
        Entry<String, String> entry = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = uRL.toExternalForm();
        if (string3.endsWith("/")) {
            string2 = string3;
            string = "";
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(uRL.getFile(), "/");
            stringBuffer.append(uRL.getProtocol());
            stringBuffer.append(":");
            stringBuffer.append(uRL.getHost());
            string2 = "";
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(string2);
                string2 = stringTokenizer.nextToken();
                stringBuffer.append("/");
            }
            string = string2;
            string2 = stringBuffer.toString();
        }
        entry = new Entry<String, String>(string2, string);
        return entry;
    }

    public static Map.Entry<String, String> cutDirectoryInformation(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        String string3 = System.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
        int n = stringTokenizer.countTokens();
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("This cannot be a filename: \"" + string + "\"");
            }
        }
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4);
                continue;
            }
            if (new File(string).isFile()) {
                string2 = string4;
                continue;
            }
            stringBuffer.append(string4);
        }
        return new Entry<String, String>(stringBuffer.toString(), string2);
    }

    public static Map.Entry<String, String> cutExtension(String string) {
        String string2;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            while (n > 1) {
                stringBuffer.append(stringTokenizer.nextToken());
                if (--n <= 1) continue;
                stringBuffer.append(".");
            }
            string2 = stringBuffer.toString();
            string3 = stringTokenizer.nextToken();
        } else {
            string2 = string;
            string3 = "";
        }
        return new Entry<String, String>(string2, string3);
    }

    public static String getDefaultFileName(String string) {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            string2 = file.getAbsolutePath();
        } else {
            Map.Entry<String, String> entry = FileUtil.cutExtension(string);
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            int n = 0;
            while (file.exists()) {
                file = new File(string3 + '_' + n + '.' + string4);
                ++n;
            }
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    public static File deriveFile(File file, String string, boolean bl) throws IOException {
        File file2 = null;
        Map.Entry<String, String> entry = FileUtil.cutExtension(file.getName());
        Map.Entry<String, String> entry2 = FileUtil.cutDirectoryInformation(file.getAbsolutePath());
        String string2 = string;
        if (bl) {
            string2 = string2 + entry.getValue();
        }
        file2 = File.createTempFile(entry.getKey(), string2, new File(entry2.getKey()));
        return file2;
    }

    public static boolean isAllASCII(File file) throws IOException {
        return FileUtil.isAllASCII(new FileInputStream(file));
    }

    public static boolean isAllASCII(InputStream inputStream) throws IOException {
        boolean bl = true;
        int n = -1;
        do {
            if ((n = inputStream.read()) <= 127) continue;
            bl = false;
            break;
        } while (n != -1);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEqual(File file, Charset charset, Charset charset2) throws IOException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream2 = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            inputStreamReader2 = new InputStreamReader((InputStream)fileInputStream2, charset2);
            int n = -1;
            int n2 = -1;
            do {
                if ((n = inputStreamReader.read()) == (n2 = inputStreamReader2.read())) continue;
                bl = false;
                break;
            } while (n != -1 && n2 != -1);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (inputStreamReader2 != null) {
                inputStreamReader2.close();
            }
        }
    }

    public static InputStream readCache(File file) throws IOException {
        return new ByteArrayInputStream(FileUtil.readRAM(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRAM(File file) throws IOException {
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                if ((n3 = ((InputStream)fileInputStream).read(byArray, n2, n - n3)) <= 0) continue;
                n2 += n3;
            } while (n3 != -1 && n2 != n);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDuplicateLineBreaks(File file) {
        String string = StringUtil.getNewLine();
        if (!file.exists()) {
            System.err.println("FileUtil.removeDuplicateLineBreak(File f): " + file.getAbsolutePath() + " does not exist!");
        } else if (file.isDirectory()) {
            System.err.println("FileUtil.removeDuplicateLineBreak(File f): " + file.getAbsolutePath() + " is a directory!");
        } else {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = bufferedInputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), string, true);
                stringBuffer = new StringBuffer();
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2.equals("") && n2 > 0) {
                        ++n2;
                        continue;
                    }
                    if (string2.equals("")) {
                        string2 = string;
                        ++n2;
                    } else {
                        n2 = 0;
                    }
                    stringBuffer.append(string2);
                }
                file.delete();
                file.createNewFile();
                outputStreamWriter = new FileWriter(file);
                outputStreamWriter.write(stringBuffer.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    private FileUtil() {
    }

    public static String formatFilesize(long l, Locale locale) {
        long l2 = Math.abs(l);
        String string = Math.abs(l) < 1024L ? MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_BYTES_1"), new Long(l2)) : (l2 < 0x100000L ? MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_KBYTES_1"), new Double((double)l2 / 1024.0)) : (l2 < 0x40000000L ? MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_MBYTES_1"), new Double((double)l / 1048576.0)) : MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_GBYTES_1"), new Double((double)l2 / 1.073741824E9))));
        return string;
    }
}

