/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.reflection;

import info.monitorenter.util.TimeStampedValue;
import info.monitorenter.util.collections.IRingBuffer;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.naming.directory.NoSuchAttributeException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRecorder
extends Thread {
    protected static final boolean VERBOSE = false;
    protected IRingBuffer<ObjectInspection> m_buffer = new RingBufferArrayFast<ObjectInspection>(100);
    protected EventListenerList m_changeListeners = new EventListenerList();
    protected Field[] m_fields;
    protected long m_interval;
    protected Object m_toinspect;

    public ObjectRecorder(Object object, long l) {
        this.m_interval = l;
        this.m_toinspect = object;
        this.setDaemon(true);
        this.m_fields = object.getClass().getDeclaredFields();
        this.start();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_changeListeners.add(ChangeListener.class, changeListener);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectRecorder objectRecorder = (ObjectRecorder)object;
        if (this.m_buffer == null ? objectRecorder.m_buffer != null : !this.m_buffer.equals(objectRecorder.m_buffer)) {
            return false;
        }
        if (this.m_changeListeners == null ? objectRecorder.m_changeListeners != null : !this.m_changeListeners.equals(objectRecorder.m_changeListeners)) {
            return false;
        }
        if (!Arrays.equals(this.m_fields, objectRecorder.m_fields)) {
            return false;
        }
        if (this.m_interval != objectRecorder.m_interval) {
            return false;
        }
        return !(this.m_toinspect == null ? objectRecorder.m_toinspect != null : !this.m_toinspect.equals(objectRecorder.m_toinspect));
    }

    protected void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.m_changeListeners.getListenerList();
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            ChangeListener changeListener = (ChangeListener)objectArray[i];
            changeListener.stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStampedValue[] getAttributeHistory(String string) throws NoSuchAttributeException {
        int n;
        int n2 = -1;
        for (n = this.m_fields.length - 1; n >= 0; --n) {
            if (!this.m_fields[n].getName().equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new NoSuchAttributeException("The Attribute with the name: " + string + " does not exist in " + this.m_toinspect.getClass().getName());
        }
        n = this.m_buffer.size();
        TimeStampedValue[] timeStampedValueArray = new TimeStampedValue[n];
        IRingBuffer<ObjectInspection> iRingBuffer = this.m_buffer;
        synchronized (iRingBuffer) {
            for (ObjectInspection objectInspection : this.m_buffer) {
                int n3 = 0;
                timeStampedValueArray[n3++] = new TimeStampedValue(objectInspection.getTime(), objectInspection.get(n2));
            }
        }
        return timeStampedValueArray;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[this.m_fields.length];
        for (int i = 0; i < this.m_fields.length; ++i) {
            stringArray[i] = this.m_fields[i].getName();
        }
        return stringArray;
    }

    public Object getInspected() {
        return this.m_toinspect;
    }

    public TimeStampedValue getLastValue(String string) throws NoSuchAttributeException {
        int n = -1;
        for (int i = this.m_fields.length - 1; i >= 0; --i) {
            if (!this.m_fields[i].getName().equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new NoSuchAttributeException("The Attribute with the name: " + string + " does not exist in " + this.m_toinspect.getClass().getName());
        }
        ObjectInspection objectInspection = this.m_buffer.getYoungest();
        return new TimeStampedValue(objectInspection.getTime(), objectInspection.get(n));
    }

    public IRingBuffer<ObjectInspection> getRingBuffer() {
        return this.m_buffer;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_buffer == null ? 0 : this.m_buffer.hashCode());
        n = 31 * n + (this.m_changeListeners == null ? 0 : this.m_changeListeners.hashCode());
        n = 31 * n + Arrays.hashCode(this.m_fields);
        n = 31 * n + (int)(this.m_interval ^ this.m_interval >>> 32);
        n = 31 * n + (this.m_toinspect == null ? 0 : this.m_toinspect.hashCode());
        return n;
    }

    public void inspect() {
        ObjectInspection objectInspection = new ObjectInspection();
        for (Field field : this.m_fields) {
            try {
                field.setAccessible(true);
                objectInspection.add(field.get(this.m_toinspect));
            }
            catch (IllegalAccessException illegalAccessException) {
                String string = field.getName();
                char[] cArray = string.toCharArray();
                cArray[0] = Character.toUpperCase(cArray[0]);
                string = new String(cArray);
                String string2 = new StringBuffer("get").append(string).toString();
                try {
                    Method method = this.m_toinspect.getClass().getDeclaredMethod(string2, new Class[0]);
                    objectInspection.add(method.invoke(this.m_toinspect, new Object[0]));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException2) {
                    illegalAccessException2.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
        this.m_buffer.add(objectInspection);
        this.fireChange();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_changeListeners.remove(ChangeListener.class, changeListener);
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.m_interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.inspect();
        }
    }

    public void setHistoryLength(int n) {
        this.m_buffer.setBufferSize(n);
    }

    public void setInterval(long l) {
        this.m_interval = l;
    }

    @Override
    public String toString() {
        return this.m_buffer.toString();
    }

    public final class ObjectInspection {
        protected long m_time = new Date().getTime();
        private final LinkedList<Object> m_values = new LinkedList();

        protected ObjectInspection() {
        }

        protected void add(Object object) {
            this.m_values.add(object);
        }

        public Object get(int n) {
            return this.m_values.get(n);
        }

        public long getTime() {
            return this.m_time;
        }

        protected void remove(Object object) {
            this.m_values.remove(object);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("\nObjectInspection:\n");
            stringBuffer.append("-----------------\n");
            stringBuffer.append("Inspected: ").append(ObjectRecorder.this.getInspected().toString()).append("\n");
            stringBuffer.append("time:      ").append(this.m_time).append("\n");
            for (int i = ObjectRecorder.this.m_fields.length - 1; i >= 0; --i) {
                stringBuffer.append(ObjectRecorder.this.m_fields[i].getName()).append(": ").append(this.m_values.get(i).toString()).append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

