/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.reflection;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.reflection.ObjectRecorder;
import info.monitorenter.util.TimeStampedValue;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObjRecorder2Trace2DAdapter
implements ChangeListener {
    private final String m_fieldname;
    private final ObjectRecorder m_inspector;
    private final long m_start = System.currentTimeMillis();
    private final ITrace2D m_view;

    public ObjRecorder2Trace2DAdapter(ITrace2D iTrace2D, Object object, String string, long l) {
        this.m_view = iTrace2D;
        this.m_fieldname = string;
        this.m_inspector = new ObjectRecorder(object, l);
        this.m_inspector.addChangeListener(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjRecorder2Trace2DAdapter objRecorder2Trace2DAdapter = (ObjRecorder2Trace2DAdapter)object;
        if (this.m_fieldname == null ? objRecorder2Trace2DAdapter.m_fieldname != null : !this.m_fieldname.equals(objRecorder2Trace2DAdapter.m_fieldname)) {
            return false;
        }
        if (this.m_inspector == null ? objRecorder2Trace2DAdapter.m_inspector != null : !this.m_inspector.equals(objRecorder2Trace2DAdapter.m_inspector)) {
            return false;
        }
        if (this.m_start != objRecorder2Trace2DAdapter.m_start) {
            return false;
        }
        return !(this.m_view == null ? objRecorder2Trace2DAdapter.m_view != null : !this.m_view.equals(objRecorder2Trace2DAdapter.m_view));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_fieldname == null ? 0 : this.m_fieldname.hashCode());
        n = 31 * n + (this.m_inspector == null ? 0 : this.m_inspector.hashCode());
        n = 31 * n + (int)(this.m_start ^ this.m_start >>> 32);
        n = 31 * n + (this.m_view == null ? 0 : this.m_view.hashCode());
        return n;
    }

    public void setInterval(long l) {
        this.m_inspector.setInterval(l);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        TimeStampedValue timeStampedValue;
        try {
            timeStampedValue = this.m_inspector.getLastValue(this.m_fieldname);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (timeStampedValue != null) {
            double d = timeStampedValue.getTime() - this.m_start;
            double d2 = Double.parseDouble(timeStampedValue.getValue().toString());
            this.m_view.addPoint(d, d2);
        }
    }
}

