/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import java.awt.Color;
import java.io.Serializable;

public class HSBColor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3257288036910903863L;
    protected double m_hue;
    protected double m_lum;
    protected double m_sat;
    protected double m_alpha;

    public static HSBColor rgbToHSB(Color color) {
        int n;
        int n2 = color.getRGB();
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        HSBColor hSBColor = new HSBColor();
        int n6 = n3 >= n4 ? (n3 >= n5 ? n3 : n5) : (n = n4 >= n5 ? n4 : n5);
        int n7 = n3 <= n4 ? (n3 <= n5 ? n3 : n5) : (n4 <= n5 ? n4 : n5);
        hSBColor.m_lum = (float)n / 255.0f;
        if (n != n7) {
            float f = n - n7;
            hSBColor.m_sat = f / (float)n;
            hSBColor.m_hue = n3 == n ? (double)((float)(n4 - n5) / f) : (n4 == n ? (double)((float)(n5 - n3) / f + 2.0f) : (double)((float)(n3 - n4) / f + 4.0f));
            hSBColor.m_hue /= 6.0;
            if (hSBColor.m_hue < 0.0) {
                hSBColor.m_hue += 1.0;
            }
        } else {
            hSBColor.m_sat = 0.0;
            hSBColor.m_hue = 0.0;
        }
        hSBColor.m_alpha = color.getAlpha();
        return hSBColor;
    }

    private HSBColor() {
    }

    HSBColor(double d, double d2, double d3) {
        this(d, d2, d3, 255);
    }

    HSBColor(double d, double d2, double d3, int n) {
        this.m_hue = d;
        this.m_sat = d2;
        this.m_lum = d3;
        this.m_alpha = n;
    }

    public HSBColor(Color color) {
        int n;
        int n2 = color.getRGB();
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        int n6 = n3 >= n4 ? (n3 >= n5 ? n3 : n5) : (n = n4 >= n5 ? n4 : n5);
        int n7 = n3 <= n4 ? (n3 <= n5 ? n3 : n5) : (n4 <= n5 ? n4 : n5);
        this.m_lum = (float)n / 255.0f;
        if (n != n7) {
            float f = n - n7;
            this.m_sat = f / (float)n;
            this.m_hue = n3 == n ? (double)((float)(n4 - n5) / f) : (n4 == n ? (double)((float)(n5 - n3) / f) + 2.0 : (double)((float)(n3 - n4) / f) + 4.0);
            this.m_hue /= 6.0;
            if (this.m_hue < 0.0) {
                this.m_hue += 1.0;
            }
        } else {
            this.m_sat = 0.0;
            this.m_hue = 0.0;
        }
        this.m_alpha = color.getAlpha();
    }

    public Object clone() {
        HSBColor hSBColor = null;
        try {
            hSBColor = (HSBColor)super.clone();
            hSBColor.m_hue = this.m_hue;
            hSBColor.m_lum = this.m_lum;
            hSBColor.m_sat = this.m_sat;
            hSBColor.m_alpha = this.m_alpha;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            hSBColor = new HSBColor((float)this.m_hue, (float)this.m_sat, (float)this.m_lum, (int)Math.round(this.m_alpha));
        }
        return hSBColor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HSBColor hSBColor = (HSBColor)object;
        if (Double.doubleToLongBits(this.m_alpha) != Double.doubleToLongBits(hSBColor.m_alpha)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_hue) != Double.doubleToLongBits(hSBColor.m_hue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_lum) != Double.doubleToLongBits(hSBColor.m_lum)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_sat) == Double.doubleToLongBits(hSBColor.m_sat);
    }

    public Color getRGBColor() {
        int n = Color.HSBtoRGB((float)this.m_hue, (float)this.m_sat, (float)this.m_lum);
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        return new Color(n2, n3, n4, (int)Math.round(this.m_alpha));
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m_alpha);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_hue);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_lum);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_sat);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

