/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import java.awt.Color;
import java.awt.Graphics;

public class ColorMutable {
    private int m_alpha = -1;
    private int m_blue = -1;
    private Color m_color;
    private int m_green = -1;
    private int m_red = -1;

    public synchronized Color applyColorIfChange(Graphics graphics) {
        Color color;
        Color color2 = null;
        if (this.m_color != null && !(color = graphics.getColor()).equals(this.m_color)) {
            color2 = color;
            graphics.setColor(this.m_color);
        }
        return color2;
    }

    public synchronized Color applyColorUnconditionally(Graphics graphics) {
        Color color = null;
        if (this.m_color != null) {
            Color color2;
            color = color2 = graphics.getColor();
            graphics.setColor(this.m_color);
        }
        return color;
    }

    private void assertColorValue(int n) {
        if (n < 0 || n > 255) {
            throw new RuntimeException("Argument has to be between 0 and 255. It is " + n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorMutable colorMutable = (ColorMutable)object;
        if (this.m_alpha != colorMutable.m_alpha) {
            return false;
        }
        if (this.m_blue != colorMutable.m_blue) {
            return false;
        }
        if (this.m_color == null ? colorMutable.m_color != null : !this.m_color.equals(colorMutable.m_color)) {
            return false;
        }
        if (this.m_green != colorMutable.m_green) {
            return false;
        }
        return this.m_red == colorMutable.m_red;
    }

    public int getAlpha() {
        return this.m_alpha;
    }

    public int getBlue() {
        return this.m_blue;
    }

    public Color getColor() {
        return this.m_color;
    }

    public int getGreen() {
        return this.m_green;
    }

    public int getRed() {
        return this.m_red;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_alpha;
        n = 31 * n + this.m_blue;
        n = 31 * n + (this.m_color == null ? 0 : this.m_color.hashCode());
        n = 31 * n + this.m_green;
        n = 31 * n + this.m_red;
        return n;
    }

    public synchronized int setAlpha(int n) {
        int n2;
        int n3 = this.m_alpha;
        this.assertColorValue(n);
        this.m_alpha = n;
        if (this.m_color != null && n != (n2 = this.m_color.getAlpha())) {
            Color color = new Color(this.m_color.getRed(), this.m_color.getGreen(), this.m_color.getBlue(), n);
            this.setColor(color);
        }
        return n3;
    }

    public synchronized int setBlue(int n) {
        int n2;
        int n3 = this.m_blue;
        this.assertColorValue(n);
        this.m_blue = n;
        if (this.m_color != null && n != (n2 = this.m_color.getBlue())) {
            Color color = new Color(this.m_color.getRed(), this.m_color.getGreen(), n, this.m_color.getAlpha());
            this.setColor(color);
        }
        return n3;
    }

    public synchronized Color setColor(Color color) {
        Color color2 = this.m_color;
        Color color3 = color;
        if (this.m_color == null) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            int n4 = color.getAlpha();
            boolean bl = false;
            if (this.m_red != -1) {
                n = this.m_red;
                bl = true;
            }
            if (this.m_green != -1) {
                n2 = this.m_green;
                bl = true;
            }
            if (this.m_blue != -1) {
                n3 = this.m_blue;
                bl = true;
            }
            if (this.m_alpha != -1) {
                n4 = this.m_alpha;
                bl = true;
            }
            if (bl) {
                color3 = new Color(n, n2, n3, n4);
            }
        }
        this.m_color = color3;
        return color2;
    }

    public synchronized int setGreen(int n) {
        int n2;
        int n3 = this.m_green;
        this.assertColorValue(n);
        this.m_green = n;
        if (this.m_color != null && n != (n2 = this.m_color.getGreen())) {
            Color color = new Color(this.m_color.getRed(), n, this.m_color.getBlue(), this.m_color.getAlpha());
            this.setColor(color);
        }
        return n3;
    }

    public synchronized int setRed(int n) {
        int n2;
        int n3 = this.m_red;
        this.assertColorValue(n);
        this.m_red = n;
        if (this.m_color != null && n != (n2 = this.m_color.getRed())) {
            Color color = new Color(this.m_red, this.m_color.getGreen(), this.m_color.getBlue(), this.m_color.getAlpha());
            this.setColor(color);
        }
        return n3;
    }
}

