/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import info.monitorenter.gui.util.HSBColor;
import info.monitorenter.gui.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorIterator
implements Iterator<Color> {
    private boolean m_ascendingDirection = true;
    private boolean m_hasnext = true;
    private boolean m_firstTime = true;
    protected HSBColor m_iterate;
    private final ISteppingModel m_resetModel;
    protected HSBColor m_startColor;
    private ISteppingModel m_stepModel;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(Messages.getString("ColorIterator.0"));
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 3258408422146715703L;
            private final ColorIterator m_color = new ColorIterator();
            {
                int n = 0;
                while (this.m_color.hasNext()) {
                    ++n;
                    this.m_color.next();
                }
                System.out.println(Messages.getString("ColorIterator.1") + n + Messages.getString("ColorIterator.2"));
                System.out.println(Messages.getString("ColorIterator.3") + n);
                this.setSize(n, 100);
                this.setPreferredSize(new Dimension(n, 100));
                this.setMinimumSize(new Dimension(n, 100));
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                this.m_color.reset();
                int n = this.getWidth();
                int n2 = this.getHeight();
                for (int i = 0; this.m_color.hasNext() && i != n; ++i) {
                    graphics.setColor(this.m_color.next());
                    graphics.drawLine(i, 0, i, n2);
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jScrollPane, "Center");
        jFrame.setLocation(200, 200);
        jFrame.setSize(new Dimension(400, 100));
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setResizable(true);
        jFrame.setVisible(true);
    }

    public ColorIterator() {
        this(Color.RED, new HueStepper(1000));
    }

    public ColorIterator(Color color, ISteppingModel iSteppingModel) {
        this.setStartColor(color);
        this.m_stepModel = iSteppingModel;
        this.m_resetModel = (ISteppingModel)this.m_stepModel.clone();
        this.m_firstTime = true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorIterator colorIterator = (ColorIterator)object;
        if (this.m_ascendingDirection != colorIterator.m_ascendingDirection) {
            return false;
        }
        if (this.m_firstTime != colorIterator.m_firstTime) {
            return false;
        }
        if (this.m_hasnext != colorIterator.m_hasnext) {
            return false;
        }
        if (this.m_iterate == null ? colorIterator.m_iterate != null : !this.m_iterate.equals(colorIterator.m_iterate)) {
            return false;
        }
        if (this.m_resetModel == null ? colorIterator.m_resetModel != null : !this.m_resetModel.equals(colorIterator.m_resetModel)) {
            return false;
        }
        if (this.m_startColor == null ? colorIterator.m_startColor != null : !this.m_startColor.equals(colorIterator.m_startColor)) {
            return false;
        }
        return !(this.m_stepModel == null ? colorIterator.m_stepModel != null : !this.m_stepModel.equals(colorIterator.m_stepModel));
    }

    public final Color getStartColor() {
        return this.m_startColor.getRGBColor();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_ascendingDirection ? 1231 : 1237);
        n = 31 * n + (this.m_firstTime ? 1231 : 1237);
        n = 31 * n + (this.m_hasnext ? 1231 : 1237);
        n = 31 * n + (this.m_iterate == null ? 0 : this.m_iterate.hashCode());
        n = 31 * n + (this.m_resetModel == null ? 0 : this.m_resetModel.hashCode());
        n = 31 * n + (this.m_startColor == null ? 0 : this.m_startColor.hashCode());
        n = 31 * n + (this.m_stepModel == null ? 0 : this.m_stepModel.hashCode());
        return n;
    }

    @Override
    public boolean hasNext() {
        return this.m_hasnext;
    }

    public final boolean isAscendingDirection() {
        return this.m_ascendingDirection;
    }

    @Override
    public Color next() throws NoSuchElementException {
        if (!this.m_hasnext) {
            throw new NoSuchElementException(Messages.getString("ColorIterator.4"));
        }
        if (!this.m_firstTime) {
            this.m_stepModel.doStep(this);
            if (this.m_iterate.equals(this.m_startColor)) {
                this.m_hasnext = false;
            }
        } else {
            this.m_firstTime = false;
        }
        return this.m_iterate.getRGBColor();
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.m_iterate = (HSBColor)this.m_startColor.clone();
        this.m_stepModel = (ISteppingModel)this.m_resetModel.clone();
        this.m_hasnext = true;
        this.m_firstTime = true;
    }

    public final void setAscendingDirection(boolean bl) {
        this.m_ascendingDirection = bl;
    }

    public final void setStartColor(Color color) {
        this.m_startColor = HSBColor.rgbToHSB(color);
        this.m_iterate = (HSBColor)this.m_startColor.clone();
    }

    public void setSteps(int n) {
        this.m_resetModel.setSteps(n);
        this.m_stepModel.setSteps(n);
    }

    public static class SaturationStepper
    extends ADefaultStepping {
        public SaturationStepper() {
        }

        public SaturationStepper(int n) {
            super(n);
        }

        public void doStep(ColorIterator colorIterator) {
            double d = colorIterator.m_iterate.m_sat;
            double d2 = colorIterator.m_startColor.m_sat;
            if (colorIterator.isAscendingDirection()) {
                d += this.m_stepping;
                if (colorIterator.m_iterate.m_sat < d2 && d > d2) {
                    d = d2;
                } else if (d > 1.0 && (d -= 1.0) > d2) {
                    d = d2;
                }
            } else {
                d -= this.m_stepping;
                if (colorIterator.m_iterate.m_sat > d2 && d < d2) {
                    d = d2;
                } else if (d < 0.0 && (d += 1.0) < d2) {
                    d = d2;
                }
            }
            colorIterator.m_iterate.m_sat = d;
        }
    }

    public static class LuminanceStepper
    extends ADefaultStepping {
        public LuminanceStepper() {
        }

        public LuminanceStepper(int n) {
            super(n);
        }

        public void doStep(ColorIterator colorIterator) {
            double d = colorIterator.m_iterate.m_lum;
            double d2 = colorIterator.m_startColor.m_lum;
            if (colorIterator.isAscendingDirection()) {
                d += this.m_stepping;
                if (colorIterator.m_iterate.m_lum < d2 && d > d2) {
                    d = d2;
                } else if (d > 1.0 && (d -= 1.0) > d2) {
                    d = d2;
                }
            } else {
                d -= this.m_stepping;
                if (colorIterator.m_iterate.m_lum > d2 && d < d2) {
                    d = d2;
                } else if (d < 0.0 && (d += 1.0) < d2) {
                    d = d2;
                }
            }
            colorIterator.m_iterate.m_lum = d;
        }
    }

    public static interface ISteppingModel
    extends Cloneable {
        public Object clone();

        public void doStep(ColorIterator var1);

        public void setSteps(int var1);
    }

    public static class HueStepper
    extends ADefaultStepping {
        public HueStepper() {
        }

        public HueStepper(int n) {
            super(n);
        }

        public void doStep(ColorIterator colorIterator) {
            double d = colorIterator.m_iterate.m_hue;
            double d2 = colorIterator.m_startColor.m_hue;
            if (colorIterator.isAscendingDirection()) {
                d += this.m_stepping;
                if (colorIterator.m_iterate.m_hue < d2 && d > d2) {
                    d = d2;
                } else if (d > 1.0 && (d -= 1.0) > d2) {
                    d = d2;
                }
            } else {
                d -= this.m_stepping;
                if (colorIterator.m_iterate.m_hue > d2 && d < d2) {
                    d = d2;
                } else if (d < 0.0 && (d += 1.0) < d2) {
                    d = d2;
                }
            }
            colorIterator.m_iterate.m_hue = d;
        }
    }

    public static class HSStepper
    extends APiggyBackStepper {
        public void doStep(ColorIterator colorIterator) {
            this.m_huestep.doStep(colorIterator);
            if (colorIterator.m_iterate.m_hue == colorIterator.m_startColor.m_hue) {
                this.m_satstep.doStep(colorIterator);
            }
        }
    }

    public static class HSBStepper
    extends APiggyBackStepper {
        public void doStep(ColorIterator colorIterator) {
            this.m_huestep.doStep(colorIterator);
            if (colorIterator.m_iterate.m_hue == colorIterator.m_startColor.m_hue) {
                this.m_satstep.doStep(colorIterator);
                if (colorIterator.m_iterate.m_sat == colorIterator.m_startColor.m_sat) {
                    this.m_lumstep.doStep(colorIterator);
                }
            }
        }
    }

    public static abstract class APiggyBackStepper
    implements ISteppingModel {
        protected HueStepper m_huestep;
        protected LuminanceStepper m_lumstep;
        protected SaturationStepper m_satstep;

        public APiggyBackStepper() {
            this(100, 100, 100);
        }

        public APiggyBackStepper(int n, int n2, int n3) {
            this.m_huestep = new HueStepper(n);
            this.m_satstep = new SaturationStepper(n2);
            this.m_lumstep = new LuminanceStepper(n3);
        }

        public Object clone() {
            try {
                APiggyBackStepper aPiggyBackStepper = (APiggyBackStepper)super.clone();
                aPiggyBackStepper.m_huestep = (HueStepper)this.m_huestep.clone();
                aPiggyBackStepper.m_satstep = (SaturationStepper)this.m_satstep.clone();
                aPiggyBackStepper.m_lumstep = (LuminanceStepper)this.m_lumstep.clone();
                return aPiggyBackStepper;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace(System.err);
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public void setSteps(int n) {
            this.m_huestep.setSteps(n);
            this.m_lumstep.setSteps(n);
            this.m_satstep.setSteps(n);
        }
    }

    public static class AlphaStepper
    extends ADefaultStepping {
        public AlphaStepper() {
        }

        public AlphaStepper(int n) {
            super(n);
        }

        public void doStep(ColorIterator colorIterator) {
            double d = colorIterator.m_iterate.m_alpha;
            double d2 = colorIterator.m_startColor.m_alpha;
            if (colorIterator.isAscendingDirection()) {
                d += this.m_stepping;
                if (colorIterator.m_iterate.m_alpha < d2 && d > d2) {
                    d = d2;
                } else if (d > 255.0 && (d -= 255.0) > d2) {
                    d = d2;
                }
            } else {
                d -= this.m_stepping;
                if (colorIterator.m_iterate.m_alpha > d2 && d < d2) {
                    d = d2;
                } else if (d < 0.0 && (d += 255.0) < d2) {
                    d = d2;
                }
            }
            colorIterator.m_iterate.m_alpha = d;
        }

        public void setSteps(int n) {
            this.m_stepping = 255.0 / (double)n;
        }
    }

    public static abstract class ADefaultStepping
    implements ISteppingModel {
        protected double m_stepping;

        public ADefaultStepping() {
            this(100);
        }

        public ADefaultStepping(int n) {
            this.setSteps(n);
        }

        public Object clone() {
            ADefaultStepping aDefaultStepping = null;
            try {
                aDefaultStepping = (ADefaultStepping)super.clone();
                aDefaultStepping.m_stepping = this.m_stepping;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return aDefaultStepping;
        }

        public void setSteps(int n) {
            this.m_stepping = 1.0 / (double)n;
        }
    }
}

