/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.views;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.annotations.IAnnotationCreator;
import info.monitorenter.gui.chart.annotations.bubble.AnnotationCreatorBubble;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.layouts.FlowLayoutCorrectMinimumSize;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class ChartPanel
extends JLayeredPane
implements PropertyChangeListener {
    private static final long serialVersionUID = 3905801963714197560L;
    private IAnnotationCreator m_annotationCreator = AnnotationCreatorBubble.getInstance();
    private final Chart2D m_chart;
    protected JPanel m_labelPanel;

    public static void main(String[] stringArray) {
        double[] dArray = new double[100];
        for (int i = 0; i < 100; ++i) {
            dArray[i] = Math.random() * (double)i + 1.0;
        }
        JFrame jFrame = new JFrame("ChartPanel demo");
        Chart2D chart2D = new Chart2D();
        Trace2DLtd trace2DLtd = new Trace2DLtd(100);
        trace2DLtd.setName("Trace 1");
        Trace2DLtd trace2DLtd2 = new Trace2DLtd(100);
        trace2DLtd2.setName("Trace 2");
        chart2D.addTrace(trace2DLtd);
        chart2D.addTrace(trace2DLtd2);
        for (int i = 0; i < 100; ++i) {
            trace2DLtd.addPoint(i + 2, dArray[i]);
            trace2DLtd2.addPoint(i + 2, 100.0 - dArray[i]);
        }
        ChartPanel chartPanel = new ChartPanel(chart2D);
        jFrame.getContentPane().add(chartPanel);
        jFrame.setSize(new Dimension(400, 600));
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setJMenuBar(LayoutFactory.getInstance().createChartMenuBar(chartPanel, false));
        jFrame.setVisible(true);
    }

    public ChartPanel(Chart2D chart2D) {
        this(chart2D, true);
    }

    public ChartPanel(Chart2D chart2D, boolean bl) {
        this.m_chart = chart2D;
        this.setBackground(chart2D.getBackground());
        chart2D.setPaintLabels(false);
        LayoutFactory layoutFactory = LayoutFactory.getInstance();
        layoutFactory.createChartPopupMenu(this, bl);
        this.setLayout(new BorderLayout());
        this.add((Component)chart2D, "Center");
        this.m_labelPanel = new JPanel();
        this.m_labelPanel.setFont(chart2D.getFont());
        this.m_labelPanel.setLayout(new FlowLayoutCorrectMinimumSize(0));
        this.m_labelPanel.setBackground(chart2D.getBackground());
        for (ITrace2D iTrace2D : chart2D) {
            JLabel jLabel = layoutFactory.createTraceContextMenuLabel(chart2D, iTrace2D, true);
            if (jLabel != null) {
                this.m_labelPanel.add(jLabel);
            }
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", this);
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        }
        this.add((Component)this.m_labelPanel, "South");
        chart2D.addPropertyChangeListener("background", this);
        chart2D.addPropertyChangeListener("IAxis.PROPERTY_ADD_REMOVE_TRACE", this);
    }

    private boolean containsTraceLabel(ITrace2D iTrace2D) {
        boolean bl = false;
        Component[] componentArray = this.m_labelPanel.getComponents();
        String string = iTrace2D.getLabel();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            JLabel jLabel = (JLabel)componentArray[i];
            if (!string.equals(jLabel.getText())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartPanel chartPanel = (ChartPanel)object;
        if (this.m_annotationCreator == null ? chartPanel.m_annotationCreator != null : !this.m_annotationCreator.equals(chartPanel.m_annotationCreator)) {
            return false;
        }
        if (this.m_chart == null ? chartPanel.m_chart != null : !this.m_chart.equals(chartPanel.m_chart)) {
            return false;
        }
        return !(this.m_labelPanel == null ? chartPanel.m_labelPanel != null : !this.m_labelPanel.equals(chartPanel.m_labelPanel));
    }

    public final IAnnotationCreator getAnnotationCreator() {
        return this.m_annotationCreator;
    }

    public final Chart2D getChart() {
        return this.m_chart;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_annotationCreator == null ? 0 : this.m_annotationCreator.hashCode());
        n = 31 * n + (this.m_chart == null ? 0 : this.m_chart.hashCode());
        n = 31 * n + (this.m_labelPanel == null ? 0 : this.m_labelPanel.hashCode());
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("background")) {
            Color color = (Color)propertyChangeEvent.getNewValue();
            this.setBackground(color);
            this.m_labelPanel.setBackground(color);
            return;
        } else if (string.equals("IAxis.PROPERTY_ADD_REMOVE_TRACE")) {
            ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getOldValue();
            ITrace2D iTrace2D2 = (ITrace2D)propertyChangeEvent.getNewValue();
            if (iTrace2D == null && iTrace2D2 != null) {
                JLabel jLabel;
                if (this.containsTraceLabel(iTrace2D2) || (jLabel = LayoutFactory.getInstance().createTraceContextMenuLabel(this.m_chart, iTrace2D2, true)) == null) return;
                this.m_labelPanel.add(jLabel);
                this.invalidate();
                this.m_labelPanel.invalidate();
                this.validateTree();
                this.m_labelPanel.doLayout();
                return;
            } else {
                Component[] componentArray;
                if (iTrace2D == null || iTrace2D2 != null) throw new IllegalArgumentException("Bad property change event for add / remove trace.");
                String string2 = iTrace2D.getLabel();
                if (StringUtil.isEmpty(string2)) return;
                for (Component component : componentArray = this.m_labelPanel.getComponents()) {
                    if (!((JLabel)component).getText().equals(string2)) continue;
                    this.disposeTraceLabel((JLabel)component, iTrace2D);
                }
            }
            return;
        } else {
            if (!string.equals("ITrace2D.PROPERTY_LABEL")) return;
            ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
            String string3 = (String)propertyChangeEvent.getOldValue();
            String string4 = (String)propertyChangeEvent.getNewValue();
            if (!StringUtil.isEmpty(string3) && StringUtil.isEmpty(string4)) {
                Component[] componentArray;
                for (Component component : componentArray = this.m_labelPanel.getComponents()) {
                    if (!((JLabel)component).getText().equals(string3)) continue;
                    ((JLabel)component).setText("<unnamed>");
                }
                return;
            } else {
                JLabel jLabel;
                if (!StringUtil.isEmpty(string3) || StringUtil.isEmpty(string4) || this.containsTraceLabel(iTrace2D) || (jLabel = LayoutFactory.getInstance().createTraceContextMenuLabel(this.m_chart, iTrace2D, true)) == null) return;
                this.m_labelPanel.add(jLabel);
                this.invalidate();
                this.m_labelPanel.invalidate();
                this.validateTree();
                this.m_labelPanel.doLayout();
            }
        }
    }

    private void disposeTraceLabel(JLabel jLabel, ITrace2D iTrace2D) {
        MouseListener[] mouseListenerArray;
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)((Object)jLabel);
        this.m_labelPanel.remove(jLabel);
        for (MouseListener mouseListener : mouseListenerArray = jLabel.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_COLOR", propertyChangeListener);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_NAME", propertyChangeListener);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", propertyChangeListener);
        this.m_labelPanel.doLayout();
        this.doLayout();
    }

    public final void setAnnotationCreator(IAnnotationCreator iAnnotationCreator) {
        this.m_annotationCreator = iAnnotationCreator;
    }
}

