/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.views;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChartCoordinateView
extends JPanel {
    private static final long serialVersionUID = 2547926983897553336L;
    protected Chart2D m_chart2D;
    protected JTextField m_xView;
    protected JTextField m_yView;
    private final transient MouseMotionListener m_mouseListener;

    public ChartCoordinateView(Chart2D chart2D) {
        this.m_chart2D = chart2D;
        this.m_xView = new JTextField(10);
        this.m_xView.setEditable(false);
        this.m_yView = new JTextField(10);
        this.m_yView.setEditable(false);
        this.m_mouseListener = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ITracePoint2D iTracePoint2D = ChartCoordinateView.this.m_chart2D.translateMousePosition(mouseEvent);
                if (iTracePoint2D != null) {
                    ChartCoordinateView.this.m_xView.setText(ChartCoordinateView.this.m_chart2D.getAxisX().getFormatter().format(iTracePoint2D.getX()));
                    ChartCoordinateView.this.m_yView.setText(ChartCoordinateView.this.m_chart2D.getAxisY().getFormatter().format(iTracePoint2D.getY()));
                }
            }
        };
        this.m_chart2D.addMouseMotionListener(this.m_mouseListener);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new JLabel("X value:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.2;
        this.add(Box.createHorizontalStrut(4));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.m_xView, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("Y value:"), gridBagConstraints);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridx = 1;
        this.add(Box.createHorizontalStrut(4));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.m_yView, gridBagConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartCoordinateView chartCoordinateView = (ChartCoordinateView)object;
        if (this.m_chart2D == null ? chartCoordinateView.m_chart2D != null : !this.m_chart2D.equals(chartCoordinateView.m_chart2D)) {
            return false;
        }
        if (this.m_xView == null ? chartCoordinateView.m_xView != null : !this.m_xView.equals(chartCoordinateView.m_xView)) {
            return false;
        }
        return !(this.m_yView == null ? chartCoordinateView.m_yView != null : !this.m_yView.equals(chartCoordinateView.m_yView));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_chart2D.removeMouseMotionListener(this.m_mouseListener);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_chart2D == null ? 0 : this.m_chart2D.hashCode());
        n = 31 * n + (this.m_xView == null ? 0 : this.m_xView.hashCode());
        n = 31 * n + (this.m_yView == null ? 0 : this.m_yView.hashCode());
        return n;
    }
}

