/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.painters;

import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import java.awt.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATracePainter
implements ITracePainter<ATracePainter> {
    private static final long serialVersionUID = -1091004082187803076L;
    private boolean m_isEnded = false;
    private ITracePoint2D m_previousPoint = new TracePoint2D(0.0, 0.0);
    private int m_previousX;
    private int m_previousY;

    @Override
    public int compareTo(ATracePainter aTracePainter) {
        return this.toString().compareTo(aTracePainter.toString());
    }

    @Override
    public void discontinue(Graphics graphics) {
        this.endPaintIteration(graphics);
        this.startPaintIteration(graphics);
    }

    @Override
    public void endPaintIteration(Graphics graphics) {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ATracePainter aTracePainter = (ATracePainter)object;
        if (this.m_isEnded != aTracePainter.m_isEnded) {
            return false;
        }
        if (this.m_previousPoint == null ? aTracePainter.m_previousPoint != null : !this.m_previousPoint.equals(aTracePainter.m_previousPoint)) {
            return false;
        }
        if (this.m_previousX != aTracePainter.m_previousX) {
            return false;
        }
        return this.m_previousY == aTracePainter.m_previousY;
    }

    protected ITracePoint2D getPreviousPoint() {
        return this.m_previousPoint;
    }

    public int getPreviousX() {
        int n = this.m_previousX;
        if (this.m_isEnded) {
            this.m_previousX = Integer.MIN_VALUE;
            if (this.m_previousY == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return n;
    }

    public int getPreviousY() {
        int n = this.m_previousY;
        if (this.m_isEnded) {
            this.m_previousY = Integer.MIN_VALUE;
            if (this.m_previousX == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_isEnded ? 1231 : 1237);
        n = 31 * n + (this.m_previousPoint == null ? 0 : this.m_previousPoint.hashCode());
        n = 31 * n + this.m_previousX;
        n = 31 * n + this.m_previousY;
        return n;
    }

    @Override
    public void paintPoint(int n, int n2, int n3, int n4, Graphics graphics, ITracePoint2D iTracePoint2D) {
        this.m_previousX = n3;
        this.m_previousY = n4;
        this.m_previousPoint = iTracePoint2D;
    }

    @Override
    public void startPaintIteration(Graphics graphics) {
    }
}

