/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.computing;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.ATrace2D;
import info.monitorenter.util.collections.IRingBuffer;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace2DArithmeticMean
extends ATrace2D {
    private static final long serialVersionUID = -4365986306182830082L;
    private final IRingBuffer<ITracePoint2D> m_pointBuffer;
    private final List<ITracePoint2D> m_points = new LinkedList<ITracePoint2D>();

    public Trace2DArithmeticMean(int n) {
        this.m_pointBuffer = new RingBufferArrayFast<ITracePoint2D>(n);
    }

    @Override
    protected boolean addPointInternal(ITracePoint2D iTracePoint2D) {
        this.m_pointBuffer.add(iTracePoint2D);
        ITracePoint2D iTracePoint2D2 = this.getArithmeticMean();
        boolean bl = this.m_points.add(iTracePoint2D2);
        this.firePointAdded(iTracePoint2D2);
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Trace2DArithmeticMean trace2DArithmeticMean = (Trace2DArithmeticMean)object;
        if (this.m_pointBuffer == null ? trace2DArithmeticMean.m_pointBuffer != null : !this.m_pointBuffer.equals(trace2DArithmeticMean.m_pointBuffer)) {
            return false;
        }
        return !(this.m_points == null ? trace2DArithmeticMean.m_points != null : !this.m_points.equals(trace2DArithmeticMean.m_points));
    }

    private ITracePoint2D getArithmeticMean() {
        ITracePoint2D iTracePoint2D;
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.m_pointBuffer.iterator();
        while (iterator.hasNext()) {
            ITracePoint2D iTracePoint2D2;
            iTracePoint2D = iTracePoint2D2 = (ITracePoint2D)iterator.next();
            d += iTracePoint2D.getX();
            d2 += iTracePoint2D.getY();
        }
        int n = this.m_pointBuffer.size();
        if (n == 0) {
            n = 1;
        }
        iTracePoint2D = this.getRenderer().getTracePointProvider().createTracePoint(d /= (double)n, d2 /= (double)n);
        return iTracePoint2D;
    }

    @Override
    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSize() {
        return this.m_points.size();
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.m_pointBuffer == null ? 0 : this.m_pointBuffer.hashCode());
        n = 31 * n + (this.m_points == null ? 0 : this.m_points.hashCode());
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.m_points.isEmpty();
    }

    @Override
    public Iterator<ITracePoint2D> iterator() {
        return this.m_points.iterator();
    }

    @Override
    protected void removeAllPointsInternal() {
        this.m_pointBuffer.clear();
        this.m_points.clear();
    }

    @Override
    protected ITracePoint2D removePointInternal(ITracePoint2D iTracePoint2D) {
        ITracePoint2D iTracePoint2D2 = this.m_points.remove(0);
        return iTracePoint2D2;
    }
}

