/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.ATrace2D;
import info.monitorenter.util.collections.IRingBuffer;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace2DLtd
extends ATrace2D
implements ITrace2D {
    private static final long serialVersionUID = -6664475237146326176L;
    protected IRingBuffer<ITracePoint2D> m_buffer;

    public Trace2DLtd() {
        this(100);
    }

    public Trace2DLtd(int n) {
        this(n, Trace2DLtd.class.getName() + "-" + ATrace2D.getInstanceCount());
    }

    public Trace2DLtd(int n, String string) {
        this.m_buffer = new RingBufferArrayFast<ITracePoint2D>(n);
        this.setName(string);
    }

    public Trace2DLtd(String string) {
        this(100, string);
    }

    @Override
    protected boolean addPointInternal(ITracePoint2D iTracePoint2D) {
        ITracePoint2D iTracePoint2D2 = this.m_buffer.add(iTracePoint2D);
        if (iTracePoint2D2 != null) {
            double d = iTracePoint2D2.getX();
            double d2 = iTracePoint2D2.getY();
            if (d >= this.m_maxX) {
                d = this.m_maxX;
                this.maxXSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d), new Double(this.m_maxX));
            } else if (d <= this.m_minX) {
                d = this.m_minX;
                this.minXSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d), new Double(this.m_minX));
            }
            if (d2 >= this.m_maxY) {
                d2 = this.m_maxY;
                this.maxYSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d2), new Double(this.m_maxY));
            } else if (d2 <= this.m_minY) {
                d2 = this.m_minY;
                this.minYSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d2), new Double(this.m_minY));
            }
            this.firePointAdded(iTracePoint2D);
            if (this.m_computingTraces.size() > 0) {
                for (ITrace2D iTrace2D : this.m_computingTraces) {
                    iTrace2D.removePoint(iTracePoint2D2);
                }
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Trace2DLtd trace2DLtd = (Trace2DLtd)object;
        return !(this.m_buffer == null ? trace2DLtd.m_buffer != null : !this.m_buffer.equals(trace2DLtd.m_buffer));
    }

    @Override
    public int getMaxSize() {
        return this.m_buffer.getBufferSize();
    }

    @Override
    public int getSize() {
        return this.m_buffer.size();
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.m_buffer == null ? 0 : this.m_buffer.hashCode());
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.m_buffer.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ITracePoint2D> iterator() {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                return this.m_buffer.iteratorL2F();
            }
        }
    }

    @Override
    public void removeAllPointsInternal() {
        this.m_buffer.clear();
    }

    @Override
    protected ITracePoint2D removePointInternal(ITracePoint2D iTracePoint2D) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxSize(int n) {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                this.m_buffer.setBufferSize(n);
                double d = this.m_minX;
                this.minXSearch();
                if (this.m_minX != d) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d), new Double(this.m_minX));
                }
                double d2 = this.m_maxX;
                this.maxXSearch();
                if (this.m_maxX != d2) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d2), new Double(this.m_maxX));
                }
                double d3 = this.m_maxY;
                this.maxYSearch();
                if (this.m_maxY != d3) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d3), new Double(this.m_maxY));
                }
                double d4 = this.m_minY;
                this.minYSearch();
                if (this.m_minY != d4) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d4), new Double(this.m_minY));
                }
            }
        }
    }
}

