/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace2DDebugger
implements ITrace2D {
    private static final long serialVersionUID = -3016496113269676817L;
    private final ITrace2D m_delegate;
    private Range m_xRange = new Range(-1.7976931348623157E308, Double.MAX_VALUE);
    private Range m_yRange = new Range(-1.7976931348623157E308, Double.MAX_VALUE);

    public Trace2DDebugger(ITrace2D iTrace2D) {
        if (iTrace2D == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.m_delegate = iTrace2D;
    }

    @Override
    public void addComputingTrace(ITrace2D iTrace2D) {
        this.m_delegate.addComputingTrace(iTrace2D);
    }

    @Override
    public boolean addErrorBarPolicy(IErrorBarPolicy<?> iErrorBarPolicy) {
        return this.m_delegate.addErrorBarPolicy(iErrorBarPolicy);
    }

    @Override
    public boolean addPoint(double d, double d2) {
        ITracePoint2D iTracePoint2D = this.getRenderer().getTracePointProvider().createTracePoint(d, d2);
        return this.addPoint(iTracePoint2D);
    }

    @Override
    public boolean addPoint(ITracePoint2D iTracePoint2D) {
        double d = iTracePoint2D.getX();
        double d2 = iTracePoint2D.getY();
        if (!this.m_xRange.isContained(d)) {
            throw new IllegalArgumentException(iTracePoint2D.toString() + " is not within the valid x-range " + this.m_xRange.toString());
        }
        if (!this.m_yRange.isContained(d2)) {
            throw new IllegalArgumentException(iTracePoint2D.toString() + " is not within the valid x-range " + this.m_xRange.toString());
        }
        return this.m_delegate.addPoint(iTracePoint2D);
    }

    @Override
    public boolean addPointHighlighter(IPointPainter<?> iPointPainter) {
        return this.m_delegate.addPointHighlighter(iPointPainter);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_delegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public boolean addTracePainter(ITracePainter<?> iTracePainter) {
        return this.m_delegate.addTracePainter(iTracePainter);
    }

    @Override
    public int compareTo(ITrace2D iTrace2D) {
        return this.m_delegate.compareTo(iTrace2D);
    }

    @Override
    public boolean containsTracePainter(ITracePainter<?> iTracePainter) {
        return this.m_delegate.containsTracePainter(iTracePainter);
    }

    @Override
    public void firePointChanged(ITracePoint2D iTracePoint2D, int n) {
        this.m_delegate.firePointChanged(iTracePoint2D, n);
    }

    @Override
    public Color getColor() {
        return this.m_delegate.getColor();
    }

    @Override
    public Set<IErrorBarPolicy<?>> getErrorBarPolicies() {
        return this.m_delegate.getErrorBarPolicies();
    }

    @Override
    public boolean getHasErrorBars() {
        return this.m_delegate.getHasErrorBars();
    }

    @Override
    public String getLabel() {
        return this.m_delegate.getLabel();
    }

    @Override
    public int getMaxSize() {
        return this.m_delegate.getMaxSize();
    }

    @Override
    public double getMaxX() {
        return this.m_delegate.getMaxX();
    }

    @Override
    public double getMaxY() {
        return this.m_delegate.getMaxY();
    }

    @Override
    public double getMinX() {
        return this.m_delegate.getMinX();
    }

    @Override
    public double getMinY() {
        return this.m_delegate.getMinY();
    }

    @Override
    public String getName() {
        return this.m_delegate.getName();
    }

    @Override
    public ITrace2D.DistancePoint getNearestPointEuclid(double d, double d2) {
        return this.m_delegate.getNearestPointEuclid(d, d2);
    }

    @Override
    public ITrace2D.DistancePoint getNearestPointManhattan(double d, double d2) {
        return this.m_delegate.getNearestPointManhattan(d, d2);
    }

    @Override
    public String getPhysicalUnits() {
        return this.m_delegate.getPhysicalUnits();
    }

    @Override
    public String getPhysicalUnitsX() {
        return this.m_delegate.getPhysicalUnitsX();
    }

    @Override
    public String getPhysicalUnitsY() {
        return this.m_delegate.getPhysicalUnitsY();
    }

    @Override
    public Set<IPointPainter<?>> getPointHighlighters() {
        return this.m_delegate.getPointHighlighters();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.m_delegate.getPropertyChangeListeners(string);
    }

    @Override
    public Chart2D getRenderer() {
        return this.m_delegate.getRenderer();
    }

    @Override
    public int getSize() {
        return this.m_delegate.getSize();
    }

    @Override
    public Stroke getStroke() {
        return this.m_delegate.getStroke();
    }

    @Override
    public final Set<ITracePainter<?>> getTracePainters() {
        return this.m_delegate.getTracePainters();
    }

    public Range getXRange() {
        return this.m_xRange;
    }

    public Range getYRange() {
        return this.m_yRange;
    }

    @Override
    public Integer getZIndex() {
        return this.m_delegate.getZIndex();
    }

    @Override
    public boolean isEmpty() {
        return this.m_delegate.isEmpty();
    }

    @Override
    public boolean isVisible() {
        return this.m_delegate.isVisible();
    }

    @Override
    public Iterator<ITracePoint2D> iterator() {
        return this.m_delegate.iterator();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.m_delegate.propertyChange(propertyChangeEvent);
    }

    @Override
    public Set<IPointPainter<?>> removeAllPointHighlighters() {
        return this.m_delegate.removeAllPointHighlighters();
    }

    @Override
    public void removeAllPoints() {
        this.m_delegate.removeAllPoints();
    }

    @Override
    public boolean removeComputingTrace(ITrace2D iTrace2D) {
        return this.m_delegate.removeComputingTrace(iTrace2D);
    }

    @Override
    public boolean removeErrorBarPolicy(IErrorBarPolicy<?> iErrorBarPolicy) {
        return this.m_delegate.removeErrorBarPolicy(iErrorBarPolicy);
    }

    @Override
    public boolean removePoint(ITracePoint2D iTracePoint2D) {
        return this.m_delegate.removePoint(iTracePoint2D);
    }

    @Override
    public boolean removePointHighlighter(IPointPainter<?> iPointPainter) {
        return this.m_delegate.removePointHighlighter(iPointPainter);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_delegate.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_delegate.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public boolean removeTracePainter(ITracePainter<?> iTracePainter) {
        return this.m_delegate.removeTracePainter(iTracePainter);
    }

    @Override
    public void setColor(Color color) {
        this.m_delegate.setColor(color);
    }

    @Override
    public Set<IErrorBarPolicy<?>> setErrorBarPolicy(IErrorBarPolicy<?> iErrorBarPolicy) {
        return this.m_delegate.setErrorBarPolicy(iErrorBarPolicy);
    }

    @Override
    public void setName(String string) {
        this.m_delegate.setName(string);
    }

    @Override
    public void setPhysicalUnits(String string, String string2) {
        this.m_delegate.setPhysicalUnits(string, string2);
    }

    @Override
    public Set<IPointPainter<?>> setPointHighlighter(IPointPainter<?> iPointPainter) {
        return this.m_delegate.setPointHighlighter(iPointPainter);
    }

    @Override
    public void setRenderer(Chart2D chart2D) {
        this.m_delegate.setRenderer(chart2D);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.m_delegate.setStroke(stroke);
    }

    @Override
    public final Set<ITracePainter<?>> setTracePainter(ITracePainter<?> iTracePainter) {
        return this.m_delegate.setTracePainter(iTracePainter);
    }

    @Override
    public void setVisible(boolean bl) {
        this.m_delegate.setVisible(bl);
    }

    public void setXRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.m_xRange = range;
    }

    public void setYRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.m_yRange = range;
    }

    @Override
    public void setZIndex(Integer n) {
        this.m_delegate.setZIndex(n);
    }

    @Override
    public boolean showsErrorBars() {
        return this.m_delegate.showsErrorBars();
    }

    @Override
    public boolean showsNegativeXErrorBars() {
        return this.m_delegate.showsNegativeXErrorBars();
    }

    @Override
    public boolean showsNegativeYErrorBars() {
        return this.m_delegate.showsNegativeYErrorBars();
    }

    @Override
    public boolean showsPositiveXErrorBars() {
        return this.m_delegate.showsPositiveXErrorBars();
    }

    @Override
    public boolean showsPositiveYErrorBars() {
        return this.m_delegate.showsPositiveYErrorBars();
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

