/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.util.SerializationUtility;
import info.monitorenter.util.StringUtil;
import info.monitorenter.util.math.MathUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATrace2D
implements ITrace2D,
Comparable<ITrace2D> {
    private static int instanceCount = 0;
    private static final long serialVersionUID = -3955095612824507919L;
    private final List<ChangeListener> m_changeListeners = new LinkedList<ChangeListener>();
    private Color m_color = Color.black;
    protected List<ITrace2D> m_computingTraces = new LinkedList<ITrace2D>();
    private Set<IErrorBarPolicy<?>> m_errorBarPolicies = new TreeSet();
    private boolean m_firsttime = true;
    protected double m_maxX;
    protected double m_maxXErrorBar = -1.7976931348623157E308;
    protected double m_maxY;
    protected double m_maxYErrorBar = -1.7976931348623157E308;
    protected double m_minX;
    protected double m_minXErrorBar = Double.MAX_VALUE;
    protected double m_minY;
    protected double m_minYErrorBar = Double.MAX_VALUE;
    protected String m_name = "";
    protected String m_physicalUnitsX = "";
    protected String m_physicalUnitsY = "";
    private Set<IPointPainter<?>> m_pointHighlighters;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    protected Object m_renderer = Boolean.FALSE;
    private transient Stroke m_stroke;
    private Set<ITracePainter<?>> m_tracePainters;
    private boolean m_visible = true;
    private Integer m_zIndex = 0 + instanceCount;

    public static int getInstanceCount() {
        return instanceCount;
    }

    public ATrace2D() {
        ++instanceCount;
        this.m_tracePainters = new LinkedHashSet();
        this.m_tracePainters.add(new TracePainterPolyline());
        this.m_pointHighlighters = new LinkedHashSet();
        this.m_stroke = new BasicStroke(1.0f);
    }

    @Override
    public void addComputingTrace(ITrace2D iTrace2D) {
        this.m_computingTraces.add(iTrace2D);
    }

    protected final void ensureInitialized() {
        if (this.m_renderer == Boolean.FALSE) {
            throw new IllegalStateException("Connect this trace (" + this.getName() + ") to a chart first before this operation (undebuggable deadlocks might occur else)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addErrorBarPolicy(IErrorBarPolicy<?> iErrorBarPolicy) {
        boolean bl = false;
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                bl = this.m_errorBarPolicies.add(iErrorBarPolicy);
                if (bl) {
                    iErrorBarPolicy.setTrace(this);
                    iErrorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.expandErrorBarBounds();
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", null, iErrorBarPolicy);
                }
            }
        }
        return bl;
    }

    @Override
    public final boolean addPoint(double d, double d2) {
        Object object;
        boolean bl = false;
        ITracePoint2D iTracePoint2D = null;
        Chart2D chart2D = this.getRenderer();
        if (chart2D != null && (object = chart2D.getTracePointProvider()) != null) {
            iTracePoint2D = object.createTracePoint(d, d2);
        }
        if (iTracePoint2D == null) {
            object = new IllegalStateException("Unable to addPoint because trace is not assigned to chart yet. Call chart.addTrace(trace) before!!!");
            throw object;
        }
        bl = this.addPoint(iTracePoint2D);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addPoint(ITracePoint2D iTracePoint2D) {
        boolean bl = false;
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                bl = this.addPointInternal(iTracePoint2D);
                if (bl) {
                    this.expandErrorBarBounds();
                    this.firePointAdded(iTracePoint2D);
                    iTracePoint2D.setListener(this);
                    if (this.m_computingTraces.size() > 0) {
                        for (ITrace2D iTrace2D : this.m_computingTraces) {
                            iTrace2D.addPoint(iTracePoint2D);
                        }
                    }
                }
                if (this.m_firsttime) {
                    this.m_minX = iTracePoint2D.getX();
                    this.m_minY = iTracePoint2D.getY();
                    this.m_maxX = iTracePoint2D.getX();
                    this.m_maxY = iTracePoint2D.getY();
                    Double d = new Double(0.0);
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", d, new Double(this.m_minX));
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", d, new Double(this.m_minY));
                    this.m_firsttime = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPointHighlighter(IPointPainter<?> iPointPainter) {
        boolean bl = false;
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                bl = this.m_pointHighlighters.add(iPointPainter);
                if (bl) {
                    this.firePropertyChange("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", null, iPointPainter);
                }
            }
        }
        return bl;
    }

    protected abstract boolean addPointInternal(ITracePoint2D var1);

    @Override
    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTracePainter(ITracePainter<?> iTracePainter) {
        boolean bl = false;
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                bl = this.m_tracePainters.add(iTracePainter);
                if (bl) {
                    this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", null, iTracePainter);
                }
            }
        }
        return bl;
    }

    @Override
    public final int compareTo(ITrace2D iTrace2D) {
        int n = this.getZIndex().compareTo(iTrace2D.getZIndex());
        if (n == 0) {
            int n2 = this.hashCode();
            int n3 = iTrace2D.hashCode();
            n = n2 - n3;
        }
        return n;
    }

    @Override
    public boolean containsTracePainter(ITracePainter<?> iTracePainter) {
        return this.m_tracePainters.contains(iTracePainter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandErrorBarBounds() {
        boolean bl;
        boolean bl2 = bl = !this.isEmpty();
        if (bl) {
            this.ensureInitialized();
            Object object = this.m_renderer;
            synchronized (object) {
                ATrace2D aTrace2D = this;
                synchronized (aTrace2D) {
                    boolean bl3;
                    if (this.showsPositiveXErrorBars()) {
                        bl3 = this.expandMaxXErrorBarBounds();
                        if (bl3) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", this, new Double(this.getMaxX()));
                        }
                    } else if (this.m_maxXErrorBar != -1.7976931348623157E308) {
                        this.m_maxXErrorBar = -1.7976931348623157E308;
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", this, new Double(this.getMaxX()));
                    }
                    if (this.showsPositiveYErrorBars()) {
                        bl3 = this.expandMaxYErrorBarBounds();
                        if (bl3) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", this, new Double(this.getMaxY()));
                        }
                    } else if (this.m_maxYErrorBar != -1.7976931348623157E308) {
                        this.m_maxYErrorBar = -1.7976931348623157E308;
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", this, new Double(this.getMaxY()));
                    }
                    if (this.showsNegativeXErrorBars()) {
                        bl3 = this.expandMinXErrorBarBounds();
                        if (bl3) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", this, new Double(this.getMinX()));
                        }
                    } else if (this.m_minXErrorBar != Double.MAX_VALUE) {
                        this.m_minXErrorBar = Double.MAX_VALUE;
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", this, new Double(this.getMinX()));
                    }
                    if (this.showsNegativeYErrorBars()) {
                        bl3 = this.expandMinYErrorBarBounds();
                        if (bl3) {
                            this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", this, new Double(this.getMinY()));
                        }
                    } else if (this.m_minYErrorBar != Double.MAX_VALUE) {
                        this.m_minYErrorBar = Double.MAX_VALUE;
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", this, new Double(this.getMinY()));
                    }
                }
            }
        }
    }

    private boolean expandMaxXErrorBarBounds() {
        double d;
        Chart2D chart2D = this.getRenderer();
        boolean bl = false;
        double d2 = -1.7976931348623157E308;
        if (chart2D != null) {
            d = -1.7976931348623157E308;
            for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
                if (!iErrorBarPolicy.isShowPositiveXErrors() || !((d = iErrorBarPolicy.getXError(this.m_maxX)) > d2)) continue;
                d2 = d;
            }
        }
        if (!MathUtil.assertEqual(this.m_maxXErrorBar, d = d2 + this.m_maxX, 1.0E-8)) {
            this.m_maxXErrorBar = d;
            bl = true;
        }
        return bl;
    }

    private boolean expandMaxYErrorBarBounds() {
        double d;
        Chart2D chart2D = this.getRenderer();
        boolean bl = false;
        double d2 = -1.7976931348623157E308;
        if (chart2D != null) {
            d = -1.7976931348623157E308;
            for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
                if (!iErrorBarPolicy.isShowPositiveYErrors() || !((d = iErrorBarPolicy.getYError(this.m_maxY)) > d2)) continue;
                d2 = d;
            }
        }
        if (!MathUtil.assertEqual(this.m_maxYErrorBar, d = d2 + this.m_maxY, 1.0E-8)) {
            this.m_maxYErrorBar = d;
            bl = true;
        }
        return bl;
    }

    private boolean expandMinXErrorBarBounds() {
        double d;
        Chart2D chart2D = this.getRenderer();
        boolean bl = false;
        double d2 = -1.7976931348623157E308;
        if (chart2D != null) {
            d = -1.7976931348623157E308;
            for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
                if (!iErrorBarPolicy.isShowNegativeXErrors() || !((d = iErrorBarPolicy.getXError(this.m_minX)) > d2)) continue;
                d2 = d;
            }
        }
        if (!MathUtil.assertEqual(this.m_minXErrorBar, d = this.m_minX - d2, 1.0E-8)) {
            this.m_minXErrorBar = d;
            bl = true;
        }
        return bl;
    }

    private boolean expandMinYErrorBarBounds() {
        double d;
        Chart2D chart2D = this.getRenderer();
        boolean bl = false;
        double d2 = -1.7976931348623157E308;
        if (chart2D != null) {
            d = -1.7976931348623157E308;
            for (IErrorBarPolicy<?> iErrorBarPolicy : this.getErrorBarPolicies()) {
                if (!iErrorBarPolicy.isShowNegativeYErrors() || !((d = iErrorBarPolicy.getYError(this.m_minY)) > d2)) continue;
                d2 = d;
            }
        }
        if (!MathUtil.assertEqual(this.m_minYErrorBar, d = this.m_minY - d2, 1.0E-8)) {
            this.m_minYErrorBar = d;
            bl = true;
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        --instanceCount;
    }

    protected void firePointAdded(ITracePoint2D iTracePoint2D) {
        this.firePointChanged(iTracePoint2D, 1);
        this.firePropertyChange("ITrace2D.PROPERTY_TRACEPOINT", null, iTracePoint2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePointChanged(ITracePoint2D iTracePoint2D, int n) {
        double d = iTracePoint2D.getX();
        double d2 = iTracePoint2D.getY();
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                if (1 == n) {
                    if (d > this.m_maxX) {
                        this.m_maxX = d;
                        this.expandMaxXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", null, new Double(this.m_maxX));
                    } else if (d < this.m_minX) {
                        this.m_minX = d;
                        this.expandMinXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", null, new Double(this.m_minX));
                    }
                    if (d2 > this.m_maxY) {
                        this.m_maxY = d2;
                        this.expandMaxYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", null, new Double(this.m_maxY));
                    } else if (d2 < this.m_minY) {
                        this.m_minY = d2;
                        this.expandMinYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", null, new Double(this.m_minY));
                    }
                }
                if (2 == n) {
                    if (d >= this.m_maxX) {
                        d = this.m_maxX;
                        this.maxXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d), new Double(this.m_maxX));
                    } else if (d <= this.m_minX) {
                        d = this.m_minX;
                        this.minXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d), new Double(this.m_minX));
                    }
                    if (d2 >= this.m_maxY) {
                        d2 = this.m_maxY;
                        this.maxYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d2), new Double(this.m_maxY));
                    } else if (d2 <= this.m_minY) {
                        d2 = this.m_minY;
                        this.minYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d2), new Double(this.m_minY));
                    }
                    if (this.getSize() == 0) {
                        this.m_firsttime = true;
                    }
                }
                if (n == 4) {
                    double d3;
                    if (d < this.m_maxX) {
                        d3 = this.m_maxX;
                        this.maxXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d3), new Double(this.m_maxX));
                    } else if (d > this.m_maxX) {
                        d3 = this.m_maxX;
                        this.m_maxX = d;
                        this.expandMaxXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d3), new Double(this.m_maxX));
                    }
                    if (d > this.m_minX) {
                        d3 = this.m_minX;
                        this.minXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d3), new Double(this.m_minX));
                    } else if (d < this.m_minX) {
                        d3 = this.m_minX;
                        this.m_minX = d;
                        this.expandMinXErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d3), new Double(this.m_minX));
                    }
                    if (d2 < this.m_maxY) {
                        d3 = this.m_maxY;
                        this.maxYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d3), new Double(this.m_maxY));
                    } else if (d2 > this.m_maxY) {
                        d3 = this.m_maxY;
                        this.m_maxY = d2;
                        this.expandMaxYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d3), new Double(this.m_maxY));
                    }
                    if (d2 > this.m_minY) {
                        d3 = this.m_minY;
                        this.minYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d3), new Double(this.m_minY));
                    } else if (d2 < this.m_minY) {
                        d3 = this.m_minY;
                        this.m_minY = d2;
                        this.expandMinYErrorBarBounds();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d3), new Double(this.m_minY));
                    }
                    this.firePropertyChange("ITrace2D.PROPERTY_POINT_CHANGED", null, iTracePoint2D);
                }
            }
        }
    }

    protected void firePointRemoved(ITracePoint2D iTracePoint2D) {
        this.firePointChanged(iTracePoint2D, 2);
        this.firePropertyChange("ITrace2D.PROPERTY_TRACEPOINT", iTracePoint2D, null);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (string.equals("ITrace2D.PROPERTY_MAX_X") || string.equals("ITrace2D.PROPERTY_MAX_Y") || string.equals("ITrace2D.PROPERTY_MIN_X") || string.equals("ITrace2D.PROPERTY_MIN_Y") || string.equals("ITrace2D.PROPERTY_TRACEPOINT") || string.equals("ITrace2D.PROPERTY_POINT_CHANGED")) {
            if (!Thread.holdsLock(this.m_renderer)) {
                throw new RuntimeException("Acquire a lock on the corresponding chart first!");
            }
            if (!Thread.holdsLock(this)) {
                throw new RuntimeException("Acquire a lock on this trace first!");
            }
        }
        this.m_propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public List<ChangeListener> getChangeListeners() {
        return new LinkedList<ChangeListener>(this.m_changeListeners);
    }

    @Override
    public final Color getColor() {
        return this.m_color;
    }

    @Override
    public final Set<IErrorBarPolicy<?>> getErrorBarPolicies() {
        return this.m_errorBarPolicies;
    }

    @Override
    public final boolean getHasErrorBars() {
        boolean bl;
        block1: {
            IErrorBarPolicy<?> iErrorBarPolicy;
            bl = false;
            if (this.m_errorBarPolicies.size() <= 0) break block1;
            Iterator<IErrorBarPolicy<?>> iterator = this.m_errorBarPolicies.iterator();
            while (!(!iterator.hasNext() || (iErrorBarPolicy = iterator.next()).getErrorBarPainters().size() > 0 && ((bl |= iErrorBarPolicy.isShowNegativeXErrors()) || (bl |= iErrorBarPolicy.isShowPositiveXErrors()) || (bl |= iErrorBarPolicy.isShowNegativeYErrors()) || (bl |= iErrorBarPolicy.isShowPositiveYErrors())))) {
            }
        }
        return bl;
    }

    @Override
    public final String getLabel() {
        String string = this.getName();
        String string2 = this.getPhysicalUnits();
        if (!StringUtil.isEmpty(string) && !StringUtil.isEmpty(string2)) {
            string = new StringBuffer(string).append(" ").append(string2).toString();
        } else if (!StringUtil.isEmpty(string2)) {
            string = new StringBuffer("unnamed").append(" ").append(string2).toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMaxX() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double d = this.m_maxX;
                if (this.m_maxXErrorBar != -1.7976931348623157E308) {
                    d = this.m_maxXErrorBar;
                }
                return d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMaxY() {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double d = this.m_maxY;
                if (this.m_maxYErrorBar != -1.7976931348623157E308) {
                    d = this.m_maxYErrorBar;
                }
                return d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMinX() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double d = this.m_minX;
                if (this.m_minXErrorBar != Double.MAX_VALUE) {
                    d = this.m_minXErrorBar;
                }
                return d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getMinY() {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                double d = this.m_minY;
                if (this.m_minYErrorBar != Double.MAX_VALUE) {
                    d = this.m_minYErrorBar;
                }
                return d;
            }
        }
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public ITrace2D.DistancePoint getNearestPointEuclid(double d, double d2) {
        ITrace2D.DistancePoint distancePoint = new ITrace2D.DistancePoint();
        Iterator<ITracePoint2D> iterator = this.iterator();
        double d3 = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            ITracePoint2D iTracePoint2D = iterator.next();
            double d4 = iTracePoint2D.getEuclidDistance(d, d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            distancePoint.setPoint(iTracePoint2D);
            distancePoint.setDistance(d3);
        }
        return distancePoint;
    }

    @Override
    public ITrace2D.DistancePoint getNearestPointManhattan(double d, double d2) {
        ITrace2D.DistancePoint distancePoint = new ITrace2D.DistancePoint();
        Iterator<ITracePoint2D> iterator = this.iterator();
        double d3 = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            ITracePoint2D iTracePoint2D = iterator.next();
            double d4 = iTracePoint2D.getManhattanDistance(d, d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            distancePoint.setPoint(iTracePoint2D);
            distancePoint.setDistance(d3);
        }
        return distancePoint;
    }

    @Override
    public final String getPhysicalUnits() {
        String string = StringUtil.isEmpty(this.m_physicalUnitsX) && StringUtil.isEmpty(this.m_physicalUnitsY) ? "" : new StringBuffer("[x: ").append(this.getPhysicalUnitsX()).append(", y: ").append(this.getPhysicalUnitsY()).append("]").toString();
        return string;
    }

    @Override
    public final String getPhysicalUnitsX() {
        return this.m_physicalUnitsX;
    }

    @Override
    public final String getPhysicalUnitsY() {
        return this.m_physicalUnitsY;
    }

    @Override
    public final Set<IPointPainter<?>> getPointHighlighters() {
        return this.m_pointHighlighters;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(string);
    }

    @Override
    public final Chart2D getRenderer() {
        Chart2D chart2D = null;
        if (this.m_renderer instanceof Chart2D) {
            chart2D = (Chart2D)this.m_renderer;
        }
        return chart2D;
    }

    @Override
    public final Stroke getStroke() {
        return this.m_stroke;
    }

    @Override
    public final Set<ITracePainter<?>> getTracePainters() {
        return this.m_tracePainters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Integer getZIndex() {
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
            }
        }
        return this.m_zIndex;
    }

    @Override
    public final boolean isVisible() {
        return this.m_visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maxXSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double d = -1.7976931348623157E308;
            ITracePoint2D iTracePoint2D = null;
            Iterator<ITracePoint2D> iterator = this.iterator();
            while (iterator.hasNext()) {
                iTracePoint2D = iterator.next();
                double d2 = iTracePoint2D.getX();
                if (!(d2 > d)) continue;
                d = d2;
            }
            this.m_maxX = d;
        }
        this.expandMaxXErrorBarBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maxYSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double d = -1.7976931348623157E308;
            ITracePoint2D iTracePoint2D = null;
            Iterator<ITracePoint2D> iterator = this.iterator();
            while (iterator.hasNext()) {
                iTracePoint2D = iterator.next();
                double d2 = iTracePoint2D.getY();
                if (!(d2 > d)) continue;
                d = d2;
            }
            this.m_maxY = d;
        }
        this.expandMaxYErrorBarBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void minXSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double d = Double.MAX_VALUE;
            ITracePoint2D iTracePoint2D = null;
            Iterator<ITracePoint2D> iterator = this.iterator();
            while (iterator.hasNext()) {
                iTracePoint2D = iterator.next();
                double d2 = iTracePoint2D.getX();
                if (!(d2 < d)) continue;
                d = d2;
            }
            this.m_minX = d;
        }
        this.expandMinXErrorBarBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void minYSearch() {
        ATrace2D aTrace2D = this;
        synchronized (aTrace2D) {
            double d = Double.MAX_VALUE;
            ITracePoint2D iTracePoint2D = null;
            Iterator<ITracePoint2D> iterator = this.iterator();
            while (iterator.hasNext()) {
                iTracePoint2D = iterator.next();
                double d2 = iTracePoint2D.getY();
                if (!(d2 < d)) continue;
                d = d2;
            }
            this.m_minY = d;
            this.expandMinYErrorBarBounds();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("IErrorBarPolicy.PROPERTY_CONFIGURATION".equals(propertyChangeEvent.getPropertyName())) {
            this.expandErrorBarBounds();
            this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", null, propertyChangeEvent.getSource());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_stroke = SerializationUtility.readStroke(objectInputStream);
    }

    @Override
    public Set<IPointPainter<?>> removeAllPointHighlighters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (IPointPainter<?> iPointPainter : this.getPointHighlighters()) {
            this.removePointHighlighter(iPointPainter);
            linkedHashSet.add(iPointPainter);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAllPoints() {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                this.m_firsttime = true;
                this.removeAllPointsInternal();
                double d = this.m_maxX;
                this.m_maxX = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d), new Double(this.m_maxX));
                d = this.m_maxY;
                this.m_maxY = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d), new Double(this.m_maxY));
                d = this.m_minX;
                this.m_minX = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d), new Double(this.m_minX));
                d = this.m_minY;
                this.m_minY = 0.0;
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d), new Double(this.m_minY));
                for (ITrace2D iTrace2D : this.m_computingTraces) {
                    iTrace2D.removeAllPoints();
                }
            }
        }
    }

    protected abstract void removeAllPointsInternal();

    @Override
    public boolean removeComputingTrace(ITrace2D iTrace2D) {
        boolean bl = this.m_computingTraces.remove(iTrace2D);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeErrorBarPolicy(IErrorBarPolicy<?> iErrorBarPolicy) {
        boolean bl = false;
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                bl = this.m_errorBarPolicies.remove(iErrorBarPolicy);
                if (bl) {
                    iErrorBarPolicy.setTrace(null);
                    iErrorBarPolicy.removePropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.expandErrorBarBounds();
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", iErrorBarPolicy, null);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePoint(ITracePoint2D iTracePoint2D) {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                ITracePoint2D iTracePoint2D2 = this.removePointInternal(iTracePoint2D);
                if (iTracePoint2D2 != null) {
                    double d = iTracePoint2D2.getX();
                    double d2 = iTracePoint2D2.getY();
                    if (d >= this.m_maxX) {
                        d = this.m_maxX;
                        this.maxXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(d), new Double(this.m_maxX));
                    } else if (d <= this.m_minX) {
                        d = this.m_minX;
                        this.minXSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(d), new Double(this.m_minX));
                    }
                    if (d2 >= this.m_maxY) {
                        d2 = this.m_maxY;
                        this.maxYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(d2), new Double(this.m_maxY));
                    } else if (d2 <= this.m_minY) {
                        d2 = this.m_minY;
                        this.minYSearch();
                        this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(d2), new Double(this.m_minY));
                    }
                    this.firePointRemoved(iTracePoint2D2);
                    iTracePoint2D2.setListener(null);
                    for (ITrace2D iTrace2D : this.m_computingTraces) {
                        iTrace2D.removePoint(iTracePoint2D2);
                    }
                }
                return iTracePoint2D2 != null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePointHighlighter(IPointPainter<?> iPointPainter) {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                boolean bl = false;
                bl = this.m_pointHighlighters.remove(iPointPainter);
                if (bl) {
                    this.firePropertyChange("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", iPointPainter, null);
                }
                return bl;
            }
        }
    }

    protected abstract ITracePoint2D removePointInternal(ITracePoint2D var1);

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public boolean removeTracePainter(ITracePainter<?> iTracePainter) {
        boolean bl = false;
        if (this.m_tracePainters.size() > 1 && (bl = this.m_tracePainters.remove(iTracePainter))) {
            this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", iTracePainter, null);
        }
        return bl;
    }

    @Override
    public final void setColor(Color color) {
        Color color2 = this.m_color;
        this.m_color = color;
        if (!this.m_color.equals(color2)) {
            this.firePropertyChange("ITrace2D.PROPERTY_COLOR", color2, this.m_color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<IErrorBarPolicy<?>> setErrorBarPolicy(IErrorBarPolicy<?> iErrorBarPolicy) {
        Set<IErrorBarPolicy<?>> set = this.m_errorBarPolicies;
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                this.m_errorBarPolicies = new TreeSet();
                boolean bl = this.m_errorBarPolicies.add(iErrorBarPolicy);
                if (bl) {
                    iErrorBarPolicy.setTrace(this);
                    this.expandErrorBarBounds();
                    iErrorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", null, iErrorBarPolicy);
                }
                for (IErrorBarPolicy<?> iErrorBarPolicy2 : set) {
                    iErrorBarPolicy2.setTrace(null);
                    iErrorBarPolicy.removePropertyChangeListener("IErrorBarPolicy.PROPERTY_CONFIGURATION", this);
                    this.firePropertyChange("ITrace2D.PROPERTY_ERRORBARPOLICY", iErrorBarPolicy2, null);
                }
            }
        }
        return set;
    }

    @Override
    public final void setName(String string) {
        String string2 = this.m_name;
        String string3 = this.getLabel();
        this.m_name = string;
        String string4 = this.getLabel();
        this.firePropertyChange("ITrace2D.PROPERTY_LABEL", string3, string4);
        this.firePropertyChange("ITrace2D.PROPERTY_NAME", string2, this.m_name);
    }

    @Override
    public final void setPhysicalUnits(String string, String string2) {
        String string3 = this.getPhysicalUnits();
        String string4 = this.getLabel();
        this.m_physicalUnitsX = string;
        this.m_physicalUnitsY = string2;
        String string5 = this.getPhysicalUnits();
        String string6 = this.getLabel();
        this.firePropertyChange("ITrace2D.PROPERTY_LABEL", string4, string6);
        this.firePropertyChange("ITrace2D.PROPERTY_PHYSICALUNITS", string3, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<IPointPainter<?>> setPointHighlighter(IPointPainter<?> iPointPainter) {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            ATrace2D aTrace2D = this;
            synchronized (aTrace2D) {
                Set<IPointPainter<?>> set = this.m_pointHighlighters;
                this.m_pointHighlighters = new LinkedHashSet();
                boolean bl = this.m_pointHighlighters.add(iPointPainter);
                if (bl) {
                    for (IPointPainter<?> iPointPainter2 : set) {
                        this.firePropertyChange("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", iPointPainter2, null);
                    }
                    this.firePropertyChange("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", null, iPointPainter);
                } else {
                    this.m_pointHighlighters = set;
                    set = null;
                }
                return set;
            }
        }
    }

    @Override
    public final void setRenderer(Chart2D chart2D) {
        boolean bl = this.m_renderer != chart2D;
        this.m_renderer = chart2D;
        if (bl) {
            this.expandErrorBarBounds();
        }
    }

    @Override
    public final void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        Stroke stroke2 = this.m_stroke;
        this.m_stroke = stroke;
        if (!this.m_stroke.equals(stroke2)) {
            this.firePropertyChange("ITrace2D.PROPERTY_STROKE", stroke2, this.m_stroke);
        }
    }

    @Override
    public final Set<ITracePainter<?>> setTracePainter(ITracePainter<?> iTracePainter) {
        Set<ITracePainter<?>> set = this.m_tracePainters;
        this.m_tracePainters = new TreeSet();
        boolean bl = this.m_tracePainters.add(iTracePainter);
        if (bl) {
            for (ITracePainter<?> iTracePainter2 : set) {
                this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", iTracePainter2, null);
            }
            this.firePropertyChange("ITrace2D.PROPERTY_PAINTERS", null, iTracePainter);
        } else {
            this.m_tracePainters = set;
            set = null;
        }
        return set;
    }

    @Override
    public final void setVisible(boolean bl) {
        boolean bl2 = this.m_visible;
        this.m_visible = bl;
        if (bl2 != this.m_visible) {
            this.firePropertyChange("ITrace2D.PROPERTY_VISIBLE", bl2, this.m_visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setZIndex(Integer n) {
        if (!n.equals(this.m_zIndex)) {
            this.ensureInitialized();
            Object object = this.m_renderer;
            synchronized (object) {
                Integer n2 = this.m_zIndex;
                ATrace2D aTrace2D = this;
                synchronized (aTrace2D) {
                    this.m_zIndex = (int)n;
                    this.firePropertyChange("ITrace2D.PROPERTY_ZINDEX", n2, this.m_zIndex);
                }
            }
        }
    }

    @Override
    public boolean showsErrorBars() {
        boolean bl = false;
        for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
            if (iErrorBarPolicy.getErrorBarPainters().size() <= 0 || !iErrorBarPolicy.isShowNegativeXErrors() && !iErrorBarPolicy.isShowNegativeYErrors() && !iErrorBarPolicy.isShowPositiveXErrors() && !iErrorBarPolicy.isShowPositiveYErrors()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean showsNegativeXErrorBars() {
        boolean bl = false;
        for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
            if (iErrorBarPolicy.getErrorBarPainters().size() <= 0 || !iErrorBarPolicy.isShowNegativeXErrors()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean showsNegativeYErrorBars() {
        boolean bl = false;
        for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
            if (iErrorBarPolicy.getErrorBarPainters().size() <= 0 || !iErrorBarPolicy.isShowNegativeYErrors()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean showsPositiveXErrorBars() {
        boolean bl = false;
        for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
            if (iErrorBarPolicy.getErrorBarPainters().size() <= 0 || !iErrorBarPolicy.isShowPositiveXErrors()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean showsPositiveYErrorBars() {
        boolean bl = false;
        for (IErrorBarPolicy<?> iErrorBarPolicy : this.m_errorBarPolicies) {
            if (iErrorBarPolicy.getErrorBarPainters().size() <= 0 || !iErrorBarPolicy.isShowPositiveYErrors()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String toString() {
        return this.getName();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerializationUtility.writeStroke(this.m_stroke, objectOutputStream);
    }
}

