/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.pointpainters;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import java.awt.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointPainterVerticalBar
extends APointPainter<PointPainterVerticalBar> {
    private static final long serialVersionUID = 659897369391828199L;
    private final Chart2D m_chart;
    private int m_halfWidth;

    public PointPainterVerticalBar(Chart2D chart2D) {
        this(4, chart2D);
    }

    public PointPainterVerticalBar(int n, Chart2D chart2D) {
        this.setBarWidth(n);
        this.m_chart = chart2D;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PointPainterVerticalBar pointPainterVerticalBar = (PointPainterVerticalBar)object;
        if (this.m_chart == null ? pointPainterVerticalBar.m_chart != null : !this.m_chart.equals(pointPainterVerticalBar.m_chart)) {
            return false;
        }
        return this.m_halfWidth == pointPainterVerticalBar.m_halfWidth;
    }

    public int getBarWidth() {
        return this.m_halfWidth;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.m_chart == null ? 0 : this.m_chart.hashCode());
        n = 31 * n + this.m_halfWidth;
        return n;
    }

    @Override
    public void paintPoint(int n, int n2, int n3, int n4, Graphics graphics, ITracePoint2D iTracePoint2D) {
        graphics.fillRect(n - this.m_halfWidth, n2, 2 * this.m_halfWidth, this.m_chart.getYChartStart() - n2);
    }

    public void setBarWidth(int n) {
        this.m_halfWidth = n / 2;
    }
}

