/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.pointpainters;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointPainterDisc
extends APointPainter<PointPainterDisc> {
    private static final long serialVersionUID = -6317473632026920774L;
    private int m_discSize;
    private int m_halfDiscSize;

    public PointPainterDisc() {
        this.setDiscSize(4);
    }

    public PointPainterDisc(int n) {
        this.setDiscSize(n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PointPainterDisc pointPainterDisc = (PointPainterDisc)object;
        if (this.m_discSize != pointPainterDisc.m_discSize) {
            return false;
        }
        return this.m_halfDiscSize == pointPainterDisc.m_halfDiscSize;
    }

    public int getDiscSize() {
        return this.m_discSize;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.m_discSize;
        n = 31 * n + this.m_halfDiscSize;
        return n;
    }

    @Override
    public void paintPoint(int n, int n2, int n3, int n4, Graphics graphics, ITracePoint2D iTracePoint2D) {
        Stroke stroke = this.installStroke(graphics);
        Color color = null;
        Color color2 = this.installColorFill(graphics);
        if (color2 != null) {
            color = color2;
            graphics.fillOval(n - this.m_halfDiscSize, n2 - this.m_halfDiscSize, this.m_discSize, this.m_discSize);
        }
        color2 = this.installColor(graphics);
        if (color == null) {
            color = color2;
        } else if (color2 == null) {
            graphics.setColor(color);
            color = null;
        }
        graphics.drawOval(n - this.m_halfDiscSize, n2 - this.m_halfDiscSize, this.m_discSize, this.m_discSize);
        if (stroke != null) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    public void setDiscSize(int n) {
        this.m_discSize = n;
        this.m_halfDiscSize = this.m_discSize / 2;
    }
}

