/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.pointpainters;

import info.monitorenter.gui.chart.IPointPainterConfigurableUI;
import info.monitorenter.gui.util.ColorMutable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APointPainter<T extends IPointPainterConfigurableUI<T>>
implements IPointPainterConfigurableUI<T> {
    private static final long serialVersionUID = -8279972259015294590L;
    private final ColorMutable m_color = new ColorMutable();
    private final ColorMutable m_colorFill = new ColorMutable();
    private Stroke m_stroke = null;

    @Override
    public final int compareTo(T t) {
        return this.hashCode() - t.hashCode();
    }

    @Override
    public void endPaintIteration(Graphics graphics) {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        APointPainter aPointPainter = (APointPainter)object;
        if (this.m_color == null ? aPointPainter.m_color != null : !this.m_color.equals(aPointPainter.m_color)) {
            return false;
        }
        if (this.m_colorFill == null ? aPointPainter.m_colorFill != null : !this.m_colorFill.equals(aPointPainter.m_colorFill)) {
            return false;
        }
        return !(this.m_stroke == null ? aPointPainter.m_stroke != null : !this.m_stroke.equals(aPointPainter.m_stroke));
    }

    @Override
    public Color getColor() {
        return this.m_color.getColor();
    }

    @Override
    public Color getColorFill() {
        return this.m_colorFill.getColor();
    }

    @Override
    public Stroke getStroke() {
        return this.m_stroke;
    }

    @Override
    public int getTransparency() {
        return this.m_color.getAlpha();
    }

    @Override
    public int getTransparencyFill() {
        return this.m_colorFill.getAlpha();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_color == null ? 0 : this.m_color.hashCode());
        n = 31 * n + (this.m_colorFill == null ? 0 : this.m_colorFill.hashCode());
        n = 31 * n + (this.m_stroke == null ? 0 : this.m_stroke.hashCode());
        return n;
    }

    protected Color installColor(Graphics graphics) {
        return this.m_color.applyColorIfChange(graphics);
    }

    protected Color installColorFill(Graphics graphics) {
        return this.m_colorFill.applyColorUnconditionally(graphics);
    }

    protected Stroke installStroke(Graphics graphics) {
        Stroke stroke = null;
        if (this.m_stroke != null) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.m_stroke);
            } else {
                System.out.println("Cannot use stroke as given graphic context is of wrong type: " + graphics.getClass().getName());
            }
        }
        return stroke;
    }

    @Override
    public Color setColor(Color color) {
        Color color2 = this.m_color.setColor(color);
        return color2;
    }

    @Override
    public Color setColorFill(Color color) {
        return this.m_colorFill.setColor(color);
    }

    @Override
    public Stroke setStroke(Stroke stroke) {
        Stroke stroke2 = this.m_stroke;
        this.m_stroke = stroke;
        return stroke2;
    }

    @Override
    public int setTransparency(int n) {
        return this.m_color.setAlpha(n);
    }

    @Override
    public int setTransparencyFill(int n) {
        return this.m_colorFill.setAlpha(n);
    }

    @Override
    public void startPaintIteration(Graphics graphics) {
    }
}

