/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.util.Range;
import info.monitorenter.util.units.AUnit;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelFormatterUnit
extends ALabelFormatter {
    private static final long serialVersionUID = -6180347628045892405L;
    private ALabelFormatter m_delegate;
    private AUnit m_unit = UNIT_UNCHANGED;

    public LabelFormatterUnit(AUnit aUnit) {
        this(aUnit, new LabelFormatterSimple());
    }

    public LabelFormatterUnit(AUnit aUnit, ALabelFormatter aLabelFormatter) {
        this.m_delegate = aLabelFormatter;
        this.m_unit = aUnit;
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_delegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public boolean equals(Object object) {
        return this.m_delegate.equals(object);
    }

    @Override
    public String format(double d) {
        double d2 = d / this.m_unit.getFactor();
        return this.m_delegate.format(d2);
    }

    @Override
    public IAxis<?> getAxis() {
        return this.m_delegate.getAxis();
    }

    final ALabelFormatter getDelegate() {
        return this.m_delegate;
    }

    @Override
    public int getMaxAmountChars() {
        int n = 0;
        Range range = this.getAxis().getRange();
        double d = range.getExtent() / this.m_unit.getFactor();
        if (d < 1.0) {
            if (d == 0.0) {
                n = 1;
            } else if (d == 0.0) {
                n = 1;
            } else {
                while (d < 1.0) {
                    d *= 10.0;
                    ++n;
                }
            }
        } else {
            n = d < 10.0 ? 2 : (d < 100.0 ? 1 : 0);
        }
        int n2 = 0;
        double d2 = range.getMax() / this.m_unit.getFactor();
        double d3 = Math.abs(range.getMin()) / this.m_unit.getFactor();
        if (d2 == 0.0 && d3 == 0.0) {
            n2 = 1;
        } else if (d2 < d3) {
            while (d3 > 1.0) {
                d3 /= 10.0;
                ++n2;
            }
        } else {
            while (d2 > 1.0) {
                d2 /= 10.0;
                ++n2;
            }
        }
        if (this.m_delegate instanceof LabelFormatterNumber) {
            NumberFormat numberFormat = ((LabelFormatterNumber)this.m_delegate).getNumberFormat();
            if (n2 > numberFormat.getMaximumIntegerDigits()) {
                numberFormat.setMaximumIntegerDigits(n2);
            }
            if (n > numberFormat.getMaximumFractionDigits()) {
                numberFormat.setMaximumFractionDigits(n);
            }
        }
        return 1 + n2 + 1 + n;
    }

    @Override
    public double getMinimumValueShiftForChange() {
        return this.m_delegate.getMinimumValueShiftForChange() * this.m_unit.getFactor();
    }

    @Override
    public double getNextEvenValue(double d, boolean bl) {
        return this.m_delegate.getNextEvenValue(d, bl);
    }

    @Override
    public AUnit getUnit() {
        return this.m_unit;
    }

    @Override
    public int hashCode() {
        return this.m_delegate.hashCode();
    }

    @Override
    public void initPaintIteration() {
        this.m_delegate.initPaintIteration();
    }

    @Override
    public Number parse(String string) throws NumberFormatException {
        double d = this.m_delegate.parse(string).doubleValue();
        return new Double(d *= this.m_unit.getFactor());
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_delegate.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void setAxis(IAxis<?> iAxis) {
        this.m_delegate.setAxis(iAxis);
    }

    final void setDelegate(ALabelFormatter aLabelFormatter) {
        this.m_delegate = aLabelFormatter;
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

