/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class LabelFormatterNumber
extends ALabelFormatter
implements IAxisLabelFormatter {
    private static final long serialVersionUID = 7659252726783423615L;
    private double m_cachedMinValueShift = Double.MAX_VALUE;
    protected NumberFormat m_numberFormat;

    public LabelFormatterNumber() {
        this.m_numberFormat = new DecimalFormat();
    }

    public LabelFormatterNumber(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Argument numberFormat must not be null.");
        }
        this.setNumberFormat(numberFormat);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LabelFormatterNumber labelFormatterNumber = (LabelFormatterNumber)object;
        if (Double.doubleToLongBits(this.m_cachedMinValueShift) != Double.doubleToLongBits(labelFormatterNumber.m_cachedMinValueShift)) {
            return false;
        }
        return !(this.m_numberFormat == null ? labelFormatterNumber.m_numberFormat != null : !this.m_numberFormat.equals(labelFormatterNumber.m_numberFormat));
    }

    public String format(double d) {
        return this.m_numberFormat.format(d);
    }

    public int getMaxAmountChars() {
        int n = this.format(this.getAxis().getMax()).length();
        int n2 = this.format(this.getAxis().getMin()).length();
        int n3 = Math.max(n, n2);
        return n3 += this.m_numberFormat.getMaximumFractionDigits();
    }

    public double getMinimumValueShiftForChange() {
        if (this.m_cachedMinValueShift == Double.MAX_VALUE) {
            int n = this.m_numberFormat.getMaximumFractionDigits();
            this.m_cachedMinValueShift = 1.0 / Math.pow(10.0, n);
        }
        return this.m_cachedMinValueShift;
    }

    public double getNextEvenValue(double d, boolean bl) {
        double d2 = Math.pow(10.0, this.m_numberFormat.getMaximumFractionDigits());
        double d3 = bl ? Math.ceil(d * d2) / d2 : Math.floor(d * d2) / d2;
        return d3;
    }

    public NumberFormat getNumberFormat() {
        return this.m_numberFormat;
    }

    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.m_cachedMinValueShift);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.m_numberFormat == null ? 0 : this.m_numberFormat.hashCode());
        return n;
    }

    public Number parse(String string) throws NumberFormatException {
        try {
            return this.m_numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = this.m_numberFormat;
        this.m_numberFormat = numberFormat;
        this.m_propertyChangeSupport.firePropertyChange("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", numberFormat2, this.m_numberFormat);
    }
}

