/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.util.Range;
import info.monitorenter.util.SimpleDateFormatAnalyzer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LabelFormatterDate
extends ALabelFormatter
implements IAxisLabelFormatter {
    private static final long serialVersionUID = -7201853569619240987L;
    private int m_cachedMaxAmountChars = Integer.MAX_VALUE;
    private SimpleDateFormat m_dateFormat;
    private double m_lastFormatted = 0.0;

    public LabelFormatterDate() {
        this((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3));
    }

    public LabelFormatterDate(SimpleDateFormat simpleDateFormat) {
        this.m_dateFormat = simpleDateFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LabelFormatterDate labelFormatterDate = (LabelFormatterDate)object;
        if (this.m_cachedMaxAmountChars != labelFormatterDate.m_cachedMaxAmountChars) {
            return false;
        }
        if (this.m_dateFormat == null ? labelFormatterDate.m_dateFormat != null : !this.m_dateFormat.equals(labelFormatterDate.m_dateFormat)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_lastFormatted) == Double.doubleToLongBits(labelFormatterDate.m_lastFormatted);
    }

    public String format(double d) {
        this.m_lastFormatted = d;
        return this.m_dateFormat.format(new Date((long)d));
    }

    final SimpleDateFormat getDateFormate() {
        return this.m_dateFormat;
    }

    public int getMaxAmountChars() {
        Range range = this.getAxis().getRange();
        double d = range.getExtent();
        if (this.m_cachedMaxAmountChars == Integer.MAX_VALUE) {
            this.m_cachedMaxAmountChars = this.m_dateFormat.format(new Date((long)d)).length();
        }
        return this.m_cachedMaxAmountChars;
    }

    public double getMinimumValueShiftForChange() {
        double d = 0.0;
        d = SimpleDateFormatAnalyzer.displaysMillisecond(this.m_dateFormat) ? 1.0 : (SimpleDateFormatAnalyzer.displaysSecond(this.m_dateFormat) ? 1000.0 : (SimpleDateFormatAnalyzer.displaysMinute(this.m_dateFormat) ? 60000.0 : (SimpleDateFormatAnalyzer.displaysHour(this.m_dateFormat) ? 360000.0 : (SimpleDateFormatAnalyzer.displaysDay(this.m_dateFormat) ? 8640000.0 : (SimpleDateFormatAnalyzer.displaysMonth(this.m_dateFormat) ? 2.6784E8 : 5.3568E8)))));
        return d;
    }

    public double getNextEvenValue(double d, boolean bl) {
        Date date = new Date((long)d);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (bl) {
            if (!SimpleDateFormatAnalyzer.displaysMillisecond(this.m_dateFormat)) {
                calendar.set(14, 0);
                if (!SimpleDateFormatAnalyzer.displaysSecond(this.m_dateFormat)) {
                    calendar.set(13, 0);
                    if (!SimpleDateFormatAnalyzer.displaysMinute(this.m_dateFormat)) {
                        calendar.set(12, 0);
                        if (!SimpleDateFormatAnalyzer.displaysHour(this.m_dateFormat)) {
                            calendar.set(10, 0);
                            if (!SimpleDateFormatAnalyzer.displaysDay(this.m_dateFormat)) {
                                calendar.set(6, 0);
                                if (!SimpleDateFormatAnalyzer.displaysMonth(this.m_dateFormat)) {
                                    calendar.set(2, 0);
                                    if (!SimpleDateFormatAnalyzer.displaysYear(this.m_dateFormat)) {
                                        calendar.set(1, 0);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (!SimpleDateFormatAnalyzer.displaysMillisecond(this.m_dateFormat)) {
            calendar.set(14, 1000);
            if (!SimpleDateFormatAnalyzer.displaysSecond(this.m_dateFormat)) {
                calendar.set(13, 60);
                if (!SimpleDateFormatAnalyzer.displaysMinute(this.m_dateFormat)) {
                    calendar.set(12, 60);
                    if (!SimpleDateFormatAnalyzer.displaysHour(this.m_dateFormat)) {
                        calendar.set(10, 24);
                        if (!SimpleDateFormatAnalyzer.displaysDay(this.m_dateFormat)) {
                            calendar.set(6, 365);
                            if (!SimpleDateFormatAnalyzer.displaysMonth(this.m_dateFormat)) {
                                calendar.set(2, 12);
                                if (!SimpleDateFormatAnalyzer.displaysYear(this.m_dateFormat)) {
                                    calendar.set(1, calendar.get(1) + 1);
                                }
                            }
                        }
                    }
                }
            }
        }
        return calendar.getTimeInMillis();
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.m_cachedMaxAmountChars;
        n = 31 * n + (this.m_dateFormat == null ? 0 : this.m_dateFormat.hashCode());
        long l = Double.doubleToLongBits(this.m_lastFormatted);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Number parse(String string) throws NumberFormatException {
        return new Double(this.m_lastFormatted);
    }

    final void setDateFormate(SimpleDateFormat simpleDateFormat) {
        this.m_dateFormat = simpleDateFormat;
    }
}

