/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.util.Range;
import info.monitorenter.util.units.AUnit;
import info.monitorenter.util.units.UnitUnchanged;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALabelFormatter
implements IAxisLabelFormatter {
    private static final long serialVersionUID = 5211073371003781159L;
    public static final AUnit UNIT_UNCHANGED = new UnitUnchanged();
    private transient IAxis<?> m_axis;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);

    protected ALabelFormatter() {
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ALabelFormatter aLabelFormatter = (ALabelFormatter)object;
        if (this.m_axis == null ? aLabelFormatter.m_axis != null : !this.m_axis.equals(aLabelFormatter.m_axis)) {
            return false;
        }
        return !(this.m_propertyChangeSupport == null ? aLabelFormatter.m_propertyChangeSupport != null : !this.m_propertyChangeSupport.equals(aLabelFormatter.m_propertyChangeSupport));
    }

    public IAxis<?> getAxis() {
        return this.m_axis;
    }

    @Override
    public int getMaxAmountChars() {
        int n = 0;
        Range range = this.m_axis.getRange();
        double d = range.getExtent();
        if (d < 1.0) {
            if (d == 0.0) {
                n = 1;
            } else {
                while (d < 1.0) {
                    d *= 10.0;
                    ++n;
                }
            }
        } else {
            if (d == 0.0) {
                d = 1.0;
            }
            n = d < 10.0 ? 2 : (d < 100.0 ? 1 : 0);
        }
        int n2 = 0;
        double d2 = range.getMax();
        double d3 = Math.abs(range.getMin());
        if (d2 == 0.0 && d3 == 0.0) {
            n2 = 1;
        } else if (d2 < d3) {
            while (d3 > 1.0) {
                d3 /= 10.0;
                ++n2;
            }
        } else {
            while (d2 > 1.0) {
                d2 /= 10.0;
                ++n2;
            }
        }
        return 1 + n2 + 1 + n;
    }

    @Override
    public AUnit getUnit() {
        return UNIT_UNCHANGED;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_propertyChangeSupport == null ? 0 : this.m_propertyChangeSupport.hashCode());
        return n;
    }

    @Override
    public void initPaintIteration() {
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void setAxis(IAxis<?> iAxis) {
        this.m_axis = iAxis;
    }
}

