/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.io;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.io.AStaticDataCollector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyFileStaticDataCollector
extends AStaticDataCollector {
    private InputStream m_source;

    public PropertyFileStaticDataCollector(ITrace2D iTrace2D, InputStream inputStream) {
        super(iTrace2D);
        this.m_source = inputStream;
    }

    public void collectData() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(this.m_source);
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        LinkedList<TracePoint2D> linkedList = new LinkedList<TracePoint2D>();
        for (Map.Entry<Object, Object> object : set) {
            linkedList.add(new TracePoint2D(Double.parseDouble((String)object.getKey()), Double.parseDouble((String)object.getValue())));
        }
        Collections.sort(linkedList);
        for (ITracePoint2D iTracePoint2D : linkedList) {
            this.m_trace.addPoint(iTracePoint2D);
        }
    }
}

