/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.io;

import info.monitorenter.gui.chart.io.INameFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public final class FileFilterExtensions
extends FileFilter
implements INameFilter {
    private String[] m_extensions;
    private boolean m_isWindows = false;

    public FileFilterExtensions(String[] stringArray) throws IllegalArgumentException {
        this.verify(stringArray);
        this.m_extensions = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.m_extensions, 0, stringArray.length);
        this.m_isWindows = this.isWindows();
    }

    public boolean accept(File file) {
        boolean bl = file.isDirectory() ? true : this.acceptNoDirectory(file.getAbsolutePath());
        return bl;
    }

    public boolean accept(String string) {
        boolean bl = this.isDirectory(string) ? true : this.acceptNoDirectory(string);
        return bl;
    }

    private boolean acceptNoDirectory(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "no.txt";
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        for (int i = this.m_extensions.length - 1; i >= 0; --i) {
            if (!this.m_extensions[i].equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_extensions.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("*.").append(this.m_extensions[i]);
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private boolean isDirectory(String string) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            new URL(string);
            bl2 = true;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        int n = string.lastIndexOf(46);
        int n2 = bl2 ? string.lastIndexOf(47) : (this.m_isWindows ? string.lastIndexOf(92) : string.lastIndexOf(47));
        bl = n2 == -1 ? n == -1 : (n == -1 ? true : n <= n2 + 1);
        return bl;
    }

    private boolean isWindows() {
        boolean bl = false;
        File[] fileArray = FileSystemView.getFileSystemView().getRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getAbsolutePath().indexOf(58) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void verify(String[] stringArray) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string = stringArray[i];
            if (string == null) {
                stringBuffer.append("Extension at index " + i + " is null!\n");
                continue;
            }
            if (string.indexOf(46) == -1) continue;
            stringBuffer.append("Extension \"" + string + "\" contains a dot!\n");
        }
        if (stringBuffer.length() > 0) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }
}

